// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_HybridRunbookWorkerResource
    {
        // Delete a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/deleteHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerResource created on azure
            // for more information of creating HybridRunbookWorkerResource, please refer to the document of HybridRunbookWorkerResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount20";
            string hybridRunbookWorkerGroupName = "myGroup";
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            ResourceIdentifier hybridRunbookWorkerResourceId = HybridRunbookWorkerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
            HybridRunbookWorkerResource hybridRunbookWorker = client.GetHybridRunbookWorkerResource(hybridRunbookWorkerResourceId);

            // invoke the operation
            await hybridRunbookWorker.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/getHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerResource created on azure
            // for more information of creating HybridRunbookWorkerResource, please refer to the document of HybridRunbookWorkerResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            ResourceIdentifier hybridRunbookWorkerResourceId = HybridRunbookWorkerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
            HybridRunbookWorkerResource hybridRunbookWorker = client.GetHybridRunbookWorkerResource(hybridRunbookWorkerResourceId);

            // invoke the operation
            HybridRunbookWorkerResource result = await hybridRunbookWorker.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HybridRunbookWorkerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/putHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerResource created on azure
            // for more information of creating HybridRunbookWorkerResource, please refer to the document of HybridRunbookWorkerResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            ResourceIdentifier hybridRunbookWorkerResourceId = HybridRunbookWorkerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
            HybridRunbookWorkerResource hybridRunbookWorker = client.GetHybridRunbookWorkerResource(hybridRunbookWorkerResourceId);

            // invoke the operation
            HybridRunbookWorkerCreateOrUpdateContent content = new HybridRunbookWorkerCreateOrUpdateContent()
            {
                VmResourceId = new ResourceIdentifier("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname"),
            };
            ArmOperation<HybridRunbookWorkerResource> lro = await hybridRunbookWorker.UpdateAsync(WaitUntil.Completed, content);
            HybridRunbookWorkerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HybridRunbookWorkerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Move a V2 hybrid worker to a different group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Move_MoveAV2HybridWorkerToADifferentGroup()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/moveHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Move" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerResource created on azure
            // for more information of creating HybridRunbookWorkerResource, please refer to the document of HybridRunbookWorkerResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            ResourceIdentifier hybridRunbookWorkerResourceId = HybridRunbookWorkerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName, hybridRunbookWorkerId);
            HybridRunbookWorkerResource hybridRunbookWorker = client.GetHybridRunbookWorkerResource(hybridRunbookWorkerResourceId);

            // invoke the operation
            HybridRunbookWorkerMoveContent content = new HybridRunbookWorkerMoveContent()
            {
                HybridRunbookWorkerGroupName = "TestHybridGroup2",
            };
            await hybridRunbookWorker.MoveAsync(content);

            Console.WriteLine($"Succeeded");
        }
    }
}
