// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_HybridRunbookWorkerCollection
    {
        // Get a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/getHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerGroupResource created on azure
            // for more information of creating HybridRunbookWorkerGroupResource, please refer to the document of HybridRunbookWorkerGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            ResourceIdentifier hybridRunbookWorkerGroupResourceId = HybridRunbookWorkerGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
            HybridRunbookWorkerGroupResource hybridRunbookWorkerGroup = client.GetHybridRunbookWorkerGroupResource(hybridRunbookWorkerGroupResourceId);

            // get the collection of this HybridRunbookWorkerResource
            HybridRunbookWorkerCollection collection = hybridRunbookWorkerGroup.GetHybridRunbookWorkers();

            // invoke the operation
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            HybridRunbookWorkerResource result = await collection.GetAsync(hybridRunbookWorkerId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HybridRunbookWorkerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/getHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerGroupResource created on azure
            // for more information of creating HybridRunbookWorkerGroupResource, please refer to the document of HybridRunbookWorkerGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            ResourceIdentifier hybridRunbookWorkerGroupResourceId = HybridRunbookWorkerGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
            HybridRunbookWorkerGroupResource hybridRunbookWorkerGroup = client.GetHybridRunbookWorkerGroupResource(hybridRunbookWorkerGroupResourceId);

            // get the collection of this HybridRunbookWorkerResource
            HybridRunbookWorkerCollection collection = hybridRunbookWorkerGroup.GetHybridRunbookWorkers();

            // invoke the operation
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            bool result = await collection.ExistsAsync(hybridRunbookWorkerId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/getHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerGroupResource created on azure
            // for more information of creating HybridRunbookWorkerGroupResource, please refer to the document of HybridRunbookWorkerGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            ResourceIdentifier hybridRunbookWorkerGroupResourceId = HybridRunbookWorkerGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
            HybridRunbookWorkerGroupResource hybridRunbookWorkerGroup = client.GetHybridRunbookWorkerGroupResource(hybridRunbookWorkerGroupResourceId);

            // get the collection of this HybridRunbookWorkerResource
            HybridRunbookWorkerCollection collection = hybridRunbookWorkerGroup.GetHybridRunbookWorkers();

            // invoke the operation
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            NullableResponse<HybridRunbookWorkerResource> response = await collection.GetIfExistsAsync(hybridRunbookWorkerId);
            HybridRunbookWorkerResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HybridRunbookWorkerData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a V2 hybrid runbook worker
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAV2HybridRunbookWorker()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/putHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerGroupResource created on azure
            // for more information of creating HybridRunbookWorkerGroupResource, please refer to the document of HybridRunbookWorkerGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            ResourceIdentifier hybridRunbookWorkerGroupResourceId = HybridRunbookWorkerGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
            HybridRunbookWorkerGroupResource hybridRunbookWorkerGroup = client.GetHybridRunbookWorkerGroupResource(hybridRunbookWorkerGroupResourceId);

            // get the collection of this HybridRunbookWorkerResource
            HybridRunbookWorkerCollection collection = hybridRunbookWorkerGroup.GetHybridRunbookWorkers();

            // invoke the operation
            string hybridRunbookWorkerId = "c010ad12-ef14-4a2a-aa9e-ef22c4745ddd";
            HybridRunbookWorkerCreateOrUpdateContent content = new HybridRunbookWorkerCreateOrUpdateContent()
            {
                VmResourceId = new ResourceIdentifier("/subscriptions/vmsubid/resourceGroups/vmrg/providers/Microsoft.Compute/virtualMachines/vmname"),
            };
            ArmOperation<HybridRunbookWorkerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, hybridRunbookWorkerId, content);
            HybridRunbookWorkerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            HybridRunbookWorkerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List hybrid workers by hybrid runbook worker group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListHybridWorkersByHybridRunbookWorkerGroup()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2021-06-22/examples/listHybridRunbookWorker.json
            // this example is just showing the usage of "HybridRunbookWorkers_ListByHybridRunbookWorkerGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this HybridRunbookWorkerGroupResource created on azure
            // for more information of creating HybridRunbookWorkerGroupResource, please refer to the document of HybridRunbookWorkerGroupResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "testaccount";
            string hybridRunbookWorkerGroupName = "TestHybridGroup";
            ResourceIdentifier hybridRunbookWorkerGroupResourceId = HybridRunbookWorkerGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, hybridRunbookWorkerGroupName);
            HybridRunbookWorkerGroupResource hybridRunbookWorkerGroup = client.GetHybridRunbookWorkerGroupResource(hybridRunbookWorkerGroupResourceId);

            // get the collection of this HybridRunbookWorkerResource
            HybridRunbookWorkerCollection collection = hybridRunbookWorkerGroup.GetHybridRunbookWorkers();

            // invoke the operation and iterate over the result
            await foreach (HybridRunbookWorkerResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                HybridRunbookWorkerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
