// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_DscNodeResource
    {
        // Delete a DSC Node
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteADSCNode()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteDscNode.json
            // this example is just showing the usage of "DscNode_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount9";
            string nodeId = "e1243a76-a9bd-432f-bde3-ad8f317ee786";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation
            await dscNode.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a node
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetANode()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getDscNode.json
            // this example is just showing the usage of "DscNode_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation
            DscNodeResource result = await dscNode.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DscNodeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a node
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateANode()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateDscNode.json
            // this example is just showing the usage of "DscNode_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation
            DscNodePatch patch = new DscNodePatch()
            {
                NodeId = "nodeId",
                DscNodeUpdateParametersName = "SetupServer.localhost",
            };
            DscNodeResource result = await dscNode.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DscNodeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List DSC reports by node id.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNodeReportsByNode_ListDSCReportsByNodeId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listDscNodeReportsByNode.json
            // this example is just showing the usage of "NodeReports_ListByNode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation and iterate over the result
            await foreach (DscNodeReport item in dscNode.GetNodeReportsByNodeAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List Paged DSC reports by node id.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNodeReportsByNode_ListPagedDSCReportsByNodeId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/listPagedDscNodeReportsByNode.json
            // this example is just showing the usage of "NodeReports_ListByNode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation and iterate over the result
            await foreach (DscNodeReport item in dscNode.GetNodeReportsByNodeAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Dsc node report data by node id and report id.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNodeReport_GetDscNodeReportDataByNodeIdAndReportId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getDscNodeReport.json
            // this example is just showing the usage of "NodeReports_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation
            string reportId = "903a5ead-140c-11e7-a943-000d3a6140c9";
            DscNodeReport result = await dscNode.GetNodeReportAsync(reportId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get content of node
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetContentNodeReport_GetContentOfNode()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getDscNodeReportContent.json
            // this example is just showing the usage of "NodeReports_GetContent" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DscNodeResource created on azure
            // for more information of creating DscNodeResource, please refer to the document of DscNodeResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string nodeId = "nodeId";
            ResourceIdentifier dscNodeResourceId = DscNodeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, nodeId);
            DscNodeResource dscNode = client.GetDscNodeResource(dscNodeResourceId);

            // invoke the operation
            string reportId = "reportId";
            BinaryData result = await dscNode.GetContentNodeReportAsync(reportId);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
