// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_AutomationSourceControlResource
    {
        // Update a source control
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateASourceControl()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControl/updateSourceControl_patch.json
            // this example is just showing the usage of "SourceControl_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "sampleAccount9";
            string sourceControlName = "sampleSourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            AutomationSourceControlPatch patch = new AutomationSourceControlPatch()
            {
                Branch = "master",
                FolderPath = "/folderOne/folderTwo",
                IsAutoSyncEnabled = true,
                IsAutoPublishRunbookEnabled = true,
                SecurityToken = new SourceControlSecurityTokenProperties()
                {
                    AccessToken = "3a326f7a0dcd343ea58fee21f2fd5fb4c1234567",
                    TokenType = SourceControlTokenType.PersonalAccessToken,
                },
                Description = "my description",
            };
            AutomationSourceControlResource result = await automationSourceControl.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationSourceControlData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a source control
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteASourceControl()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControl/deleteSourceControl.json
            // this example is just showing the usage of "SourceControl_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "sampleAccount9";
            string sourceControlName = "sampleSourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            await automationSourceControl.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a source control
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASourceControl()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControl/getSourceControl.json
            // this example is just showing the usage of "SourceControl_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "sampleAccount9";
            string sourceControlName = "sampleSourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            AutomationSourceControlResource result = await automationSourceControl.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationSourceControlData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a source control sync job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateSourceControlSyncJob_CreateOrUpdateASourceControlSyncJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControlSyncJob/createSourceControlSyncJob.json
            // this example is just showing the usage of "SourceControlSyncJob_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string sourceControlName = "MySourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            Guid sourceControlSyncJobId = Guid.Parse("ce6fe3e3-9db3-4096-a6b4-82bfb4c10a9a");
            SourceControlSyncJobCreateContent content = new SourceControlSyncJobCreateContent("9de0980bfb45026a3d97a1b0522d98a9f604226e");
            SourceControlSyncJob result = await automationSourceControl.CreateSourceControlSyncJobAsync(sourceControlSyncJobId, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a source control sync job by job id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSourceControlSyncJob_GetASourceControlSyncJobByJobId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControlSyncJob/getSourceControlSyncJob.json
            // this example is just showing the usage of "SourceControlSyncJob_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string sourceControlName = "MySourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            Guid sourceControlSyncJobId = Guid.Parse("ce6fe3e3-9db3-4096-a6b4-82bfb4c10a9a");
            SourceControlSyncJobResult result = await automationSourceControl.GetSourceControlSyncJobAsync(sourceControlSyncJobId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a list of source control sync jobs
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSourceControlSyncJobs_GetAListOfSourceControlSyncJobs()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControlSyncJob/getAllSourceControlSyncJobs.json
            // this example is just showing the usage of "SourceControlSyncJob_ListByAutomationAccount" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string sourceControlName = "MySourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation and iterate over the result
            await foreach (SourceControlSyncJob item in automationSourceControl.GetSourceControlSyncJobsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a list of sync job streams identified by sync job id
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSourceControlSyncJobStreams_GetAListOfSyncJobStreamsIdentifiedBySyncJobId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControlSyncJobStreams/getSourceControlSyncJobStreams.json
            // this example is just showing the usage of "SourceControlSyncJobStreams_ListBySyncJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string sourceControlName = "MySourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation and iterate over the result
            Guid sourceControlSyncJobId = Guid.Parse("ce6fe3e3-9db3-4096-a6b4-82bfb4c10a2b");
            await foreach (SourceControlSyncJobStream item in automationSourceControl.GetSourceControlSyncJobStreamsAsync(sourceControlSyncJobId))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a sync job stream identified by sync job stream id.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSourceControlSyncJobStream_GetASyncJobStreamIdentifiedBySyncJobStreamId()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/sourceControlSyncJobStreams/getSourceControlSyncJobStreamsByStreamId.json
            // this example is just showing the usage of "SourceControlSyncJobStreams_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationSourceControlResource created on azure
            // for more information of creating AutomationSourceControlResource, please refer to the document of AutomationSourceControlResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string sourceControlName = "MySourceControl";
            ResourceIdentifier automationSourceControlResourceId = AutomationSourceControlResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, sourceControlName);
            AutomationSourceControlResource automationSourceControl = client.GetAutomationSourceControlResource(automationSourceControlResourceId);

            // invoke the operation
            Guid sourceControlSyncJobId = Guid.Parse("ce6fe3e3-9db3-4096-a6b4-82bfb4c10a2b");
            string streamId = "b86c5c31-e9fd-4734-8764-ddd6c101e706_00636596855139029522_00000000000000000007";
            SourceControlSyncJobStreamResult result = await automationSourceControl.GetSourceControlSyncJobStreamAsync(sourceControlSyncJobId, streamId);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
