// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_AutomationScheduleResource
    {
        // Update a schedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateASchedule()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateSchedule.json
            // this example is just showing the usage of "Schedule_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationScheduleResource created on azure
            // for more information of creating AutomationScheduleResource, please refer to the document of AutomationScheduleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string scheduleName = "mySchedule";
            ResourceIdentifier automationScheduleResourceId = AutomationScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, scheduleName);
            AutomationScheduleResource automationSchedule = client.GetAutomationScheduleResource(automationScheduleResourceId);

            // invoke the operation
            AutomationSchedulePatch patch = new AutomationSchedulePatch()
            {
                Name = "mySchedule",
                Description = "my updated description of schedule goes here",
                IsEnabled = false,
            };
            AutomationScheduleResource result = await automationSchedule.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a schedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASchedule()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getSchedule.json
            // this example is just showing the usage of "Schedule_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationScheduleResource created on azure
            // for more information of creating AutomationScheduleResource, please refer to the document of AutomationScheduleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string scheduleName = "mySchedule";
            ResourceIdentifier automationScheduleResourceId = AutomationScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, scheduleName);
            AutomationScheduleResource automationSchedule = client.GetAutomationScheduleResource(automationScheduleResourceId);

            // invoke the operation
            AutomationScheduleResource result = await automationSchedule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete schedule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteSchedule()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteSchedule.json
            // this example is just showing the usage of "Schedule_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationScheduleResource created on azure
            // for more information of creating AutomationScheduleResource, please refer to the document of AutomationScheduleResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string scheduleName = "mySchedule";
            ResourceIdentifier automationScheduleResourceId = AutomationScheduleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, scheduleName);
            AutomationScheduleResource automationSchedule = client.GetAutomationScheduleResource(automationScheduleResourceId);

            // invoke the operation
            await automationSchedule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
