// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_AutomationJobResource
    {
        // Get Job Output
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetOutput_GetJobOutput()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/getJobOutput.json
            // this example is just showing the usage of "Job_GetOutput" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            string result = await automationJob.GetOutputAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Job Runbook Content
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRunbookContent_GetJobRunbookContent()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/getJobRunbookContent.json
            // this example is just showing the usage of "Job_GetRunbookContent" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            string result = await automationJob.GetRunbookContentAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Suspend job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Suspend_SuspendJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/suspendJob.json
            // this example is just showing the usage of "Job_Suspend" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            await automationJob.SuspendAsync();

            Console.WriteLine($"Succeeded");
        }

        // Stop job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Stop_StopJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/stopJob.json
            // this example is just showing the usage of "Job_Stop" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            await automationJob.StopAsync();

            Console.WriteLine($"Succeeded");
        }

        // Get job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/getJob.json
            // this example is just showing the usage of "Job_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            AutomationJobResource result = await automationJob.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/createJob.json
            // this example is just showing the usage of "Job_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            AutomationJobCreateOrUpdateContent content = new AutomationJobCreateOrUpdateContent()
            {
                RunbookName = "TestRunbook",
                Parameters =
{
["key01"] = "value01",
["key02"] = "value02",
},
                RunOn = "",
            };
            ArmOperation<AutomationJobResource> lro = await automationJob.UpdateAsync(WaitUntil.Completed, content);
            AutomationJobResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resume job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resume_ResumeJob()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/resumeJob.json
            // this example is just showing the usage of "Job_Resume" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            await automationJob.ResumeAsync();

            Console.WriteLine($"Succeeded");
        }

        // Get job stream
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetJobStream_GetJobStream()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/getJobStream.json
            // this example is just showing the usage of "JobStream_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation
            string jobStreamId = "851b2101-686f-40e2-8a4b-5b8df08afbd1_00636535684910693884_00000000000000000001";
            AutomationJobStream result = await automationJob.GetJobStreamAsync(jobStreamId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // List job streams by job name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetJobStreams_ListJobStreamsByJobName()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/stable/2019-06-01/examples/job/listJobStreamsByJob.json
            // this example is just showing the usage of "JobStream_ListByJob" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationJobResource created on azure
            // for more information of creating AutomationJobResource, please refer to the document of AutomationJobResource
            string subscriptionId = "51766542-3ed7-4a72-a187-0c8ab644ddab";
            string resourceGroupName = "mygroup";
            string automationAccountName = "ContoseAutomationAccount";
            string jobName = "foo";
            ResourceIdentifier automationJobResourceId = AutomationJobResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, jobName);
            AutomationJobResource automationJob = client.GetAutomationJobResource(automationJobResourceId);

            // invoke the operation and iterate over the result
            await foreach (AutomationJobStream item in automationJob.GetJobStreamsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
