// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_AutomationCredentialResource
    {
        // Delete a credential
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteACredential()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteCredentialExisting.json
            // this example is just showing the usage of "Credential_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCredentialResource created on azure
            // for more information of creating AutomationCredentialResource, please refer to the document of AutomationCredentialResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount20";
            string credentialName = "myCredential";
            ResourceIdentifier automationCredentialResourceId = AutomationCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, credentialName);
            AutomationCredentialResource automationCredential = client.GetAutomationCredentialResource(automationCredentialResourceId);

            // invoke the operation
            await automationCredential.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a credential
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetACredential()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getCredential.json
            // this example is just showing the usage of "Credential_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCredentialResource created on azure
            // for more information of creating AutomationCredentialResource, please refer to the document of AutomationCredentialResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount18";
            string credentialName = "myCredential";
            ResourceIdentifier automationCredentialResourceId = AutomationCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, credentialName);
            AutomationCredentialResource automationCredential = client.GetAutomationCredentialResource(automationCredentialResourceId);

            // invoke the operation
            AutomationCredentialResource result = await automationCredential.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationCredentialData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a credential
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateACredential()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateCredential_patch.json
            // this example is just showing the usage of "Credential_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCredentialResource created on azure
            // for more information of creating AutomationCredentialResource, please refer to the document of AutomationCredentialResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount18";
            string credentialName = "myCredential";
            ResourceIdentifier automationCredentialResourceId = AutomationCredentialResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, credentialName);
            AutomationCredentialResource automationCredential = client.GetAutomationCredentialResource(automationCredentialResourceId);

            // invoke the operation
            AutomationCredentialPatch patch = new AutomationCredentialPatch()
            {
                Name = "myCredential",
                UserName = "mylingaiah",
                Password = "<password>",
                Description = "my description goes here",
            };
            AutomationCredentialResource result = await automationCredential.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationCredentialData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
