// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Automation.Models;

namespace Azure.ResourceManager.Automation.Samples
{
    public partial class Sample_AutomationCertificateResource
    {
        // Delete a certificate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteACertificate()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/deleteCertificate.json
            // this example is just showing the usage of "Certificate_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCertificateResource created on azure
            // for more information of creating AutomationCertificateResource, please refer to the document of AutomationCertificateResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string certificateName = "testCert";
            ResourceIdentifier automationCertificateResourceId = AutomationCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, certificateName);
            AutomationCertificateResource automationCertificate = client.GetAutomationCertificateResource(automationCertificateResourceId);

            // invoke the operation
            await automationCertificate.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a certificate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetACertificate()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/getCertificate.json
            // this example is just showing the usage of "Certificate_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCertificateResource created on azure
            // for more information of creating AutomationCertificateResource, please refer to the document of AutomationCertificateResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string certificateName = "testCert";
            ResourceIdentifier automationCertificateResourceId = AutomationCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, certificateName);
            AutomationCertificateResource automationCertificate = client.GetAutomationCertificateResource(automationCertificateResourceId);

            // invoke the operation
            AutomationCertificateResource result = await automationCertificate.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationCertificateData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update a certificate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateACertificate()
        {
            // Generated from example definition: specification/automation/resource-manager/Microsoft.Automation/preview/2020-01-13-preview/examples/updateCertificate.json
            // this example is just showing the usage of "Certificate_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AutomationCertificateResource created on azure
            // for more information of creating AutomationCertificateResource, please refer to the document of AutomationCertificateResource
            string subscriptionId = "subid";
            string resourceGroupName = "rg";
            string automationAccountName = "myAutomationAccount33";
            string certificateName = "testCert";
            ResourceIdentifier automationCertificateResourceId = AutomationCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, automationAccountName, certificateName);
            AutomationCertificateResource automationCertificate = client.GetAutomationCertificateResource(automationCertificateResourceId);

            // invoke the operation
            AutomationCertificatePatch patch = new AutomationCertificatePatch()
            {
                Name = "testCert",
                Description = "sample certificate. Description updated",
            };
            AutomationCertificateResource result = await automationCertificate.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AutomationCertificateData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
