// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Automanage.Models
{
    /// <summary> Definition of the configuration profile. </summary>
    public partial class AutomanageConfigurationProfilePatch : AutomanageResourceUpdateDetails
    {
        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfilePatch"/>. </summary>
        public AutomanageConfigurationProfilePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfilePatch"/>. </summary>
        /// <param name="tags"> The tags of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Properties of the configuration profile. </param>
        internal AutomanageConfigurationProfilePatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ConfigurationProfileProperties properties) : base(tags, serializedAdditionalRawData)
        {
            Properties = properties;
        }

        /// <summary> Properties of the configuration profile. </summary>
        internal ConfigurationProfileProperties Properties { get; set; }
        /// <summary>
        /// configuration dictionary of the configuration profile.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Configuration
        {
            get => Properties is null ? default : Properties.Configuration;
            set
            {
                if (Properties is null)
                    Properties = new ConfigurationProfileProperties();
                Properties.Configuration = value;
            }
        }
    }
}
