// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Automanage.Models
{
    /// <summary> Automanage configuration profile assignment properties. </summary>
    public partial class AutomanageConfigurationProfileAssignmentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfileAssignmentProperties"/>. </summary>
        public AutomanageConfigurationProfileAssignmentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfileAssignmentProperties"/>. </summary>
        /// <param name="configurationProfile"> The Automanage configurationProfile ARM Resource URI. </param>
        /// <param name="targetId"> The target VM resource URI. </param>
        /// <param name="status"> The status of onboarding, which only appears in the response. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomanageConfigurationProfileAssignmentProperties(ResourceIdentifier configurationProfile, ResourceIdentifier targetId, string status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConfigurationProfile = configurationProfile;
            TargetId = targetId;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Automanage configurationProfile ARM Resource URI. </summary>
        public ResourceIdentifier ConfigurationProfile { get; set; }
        /// <summary> The target VM resource URI. </summary>
        public ResourceIdentifier TargetId { get; }
        /// <summary> The status of onboarding, which only appears in the response. </summary>
        public string Status { get; }
    }
}
