// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automanage.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableAutomanageTenantResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageTenantResource"/> class for mocking. </summary>
        protected MockableAutomanageTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAutomanageTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AutomanageBestPracticeResources in the TenantResource. </summary>
        /// <returns> An object representing collection of AutomanageBestPracticeResources and their operations over a AutomanageBestPracticeResource. </returns>
        public virtual AutomanageBestPracticeCollection GetAutomanageBestPractices()
        {
            return GetCachedClient(client => new AutomanageBestPracticeCollection(client, Id));
        }

        /// <summary>
        /// Get information about a Automanage best practice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Automanage/bestPractices/{bestPracticeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BestPractices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageBestPracticeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bestPracticeName"> The Automanage best practice name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="bestPracticeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="bestPracticeName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutomanageBestPracticeResource>> GetAutomanageBestPracticeAsync(string bestPracticeName, CancellationToken cancellationToken = default)
        {
            return await GetAutomanageBestPractices().GetAsync(bestPracticeName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about a Automanage best practice
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Automanage/bestPractices/{bestPracticeName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BestPractices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageBestPracticeResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="bestPracticeName"> The Automanage best practice name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="bestPracticeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="bestPracticeName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutomanageBestPracticeResource> GetAutomanageBestPractice(string bestPracticeName, CancellationToken cancellationToken = default)
        {
            return GetAutomanageBestPractices().Get(bestPracticeName, cancellationToken);
        }
    }
}
