// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automanage.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableAutomanageResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageResourceGroupResource"/> class for mocking. </summary>
        protected MockableAutomanageResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAutomanageResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AutomanageConfigurationProfileResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of AutomanageConfigurationProfileResources and their operations over a AutomanageConfigurationProfileResource. </returns>
        public virtual AutomanageConfigurationProfileCollection GetAutomanageConfigurationProfiles()
        {
            return GetCachedClient(client => new AutomanageConfigurationProfileCollection(client, Id));
        }

        /// <summary>
        /// Get information about a configuration profile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageConfigurationProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationProfileName"> The configuration profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutomanageConfigurationProfileResource>> GetAutomanageConfigurationProfileAsync(string configurationProfileName, CancellationToken cancellationToken = default)
        {
            return await GetAutomanageConfigurationProfiles().GetAsync(configurationProfileName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about a configuration profile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Automanage/configurationProfiles/{configurationProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageConfigurationProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="configurationProfileName"> The configuration profile name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutomanageConfigurationProfileResource> GetAutomanageConfigurationProfile(string configurationProfileName, CancellationToken cancellationToken = default)
        {
            return GetAutomanageConfigurationProfiles().Get(configurationProfileName, cancellationToken);
        }
    }
}
