// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Automanage.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableAutomanageArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageArmClient"/> class for mocking. </summary>
        protected MockableAutomanageArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAutomanageArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAutomanageArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableAutomanageArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of AutomanageVmConfigurationProfileAssignmentResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of AutomanageVmConfigurationProfileAssignmentResources and their operations over a AutomanageVmConfigurationProfileAssignmentResource. </returns>
        public virtual AutomanageVmConfigurationProfileAssignmentCollection GetAutomanageVmConfigurationProfileAssignments(ResourceIdentifier scope)
        {
            if (!scope.ResourceType.Equals("Microsoft.Compute/virtualMachines"))
            {
                throw new ArgumentException(string.Format("Invalid resource type {0}, expected Microsoft.Compute/virtualMachines", scope.ResourceType));
            }
            return new AutomanageVmConfigurationProfileAssignmentCollection(Client, scope);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageVmConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutomanageVmConfigurationProfileAssignmentResource>> GetAutomanageVmConfigurationProfileAssignmentAsync(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return await GetAutomanageVmConfigurationProfileAssignments(scope).GetAsync(configurationProfileAssignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageVmConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutomanageVmConfigurationProfileAssignmentResource> GetAutomanageVmConfigurationProfileAssignment(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return GetAutomanageVmConfigurationProfileAssignments(scope).Get(configurationProfileAssignmentName, cancellationToken);
        }

        /// <summary> Gets a collection of AutomanageHcrpConfigurationProfileAssignmentResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of AutomanageHcrpConfigurationProfileAssignmentResources and their operations over a AutomanageHcrpConfigurationProfileAssignmentResource. </returns>
        public virtual AutomanageHcrpConfigurationProfileAssignmentCollection GetAutomanageHcrpConfigurationProfileAssignments(ResourceIdentifier scope)
        {
            if (!scope.ResourceType.Equals("Microsoft.HybridCompute/machines"))
            {
                throw new ArgumentException(string.Format("Invalid resource type {0}, expected Microsoft.HybridCompute/machines", scope.ResourceType));
            }
            return new AutomanageHcrpConfigurationProfileAssignmentCollection(Client, scope);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileHCRPAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutomanageHcrpConfigurationProfileAssignmentResource>> GetAutomanageHcrpConfigurationProfileAssignmentAsync(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return await GetAutomanageHcrpConfigurationProfileAssignments(scope).GetAsync(configurationProfileAssignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileHCRPAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutomanageHcrpConfigurationProfileAssignmentResource> GetAutomanageHcrpConfigurationProfileAssignment(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return GetAutomanageHcrpConfigurationProfileAssignments(scope).Get(configurationProfileAssignmentName, cancellationToken);
        }

        /// <summary> Gets a collection of AutomanageHciClusterConfigurationProfileAssignmentResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of AutomanageHciClusterConfigurationProfileAssignmentResources and their operations over a AutomanageHciClusterConfigurationProfileAssignmentResource. </returns>
        public virtual AutomanageHciClusterConfigurationProfileAssignmentCollection GetAutomanageHciClusterConfigurationProfileAssignments(ResourceIdentifier scope)
        {
            if (!scope.ResourceType.Equals("Microsoft.AzureStackHci/clusters"))
            {
                throw new ArgumentException(string.Format("Invalid resource type {0}, expected Microsoft.AzureStackHci/clusters", scope.ResourceType));
            }
            return new AutomanageHciClusterConfigurationProfileAssignmentCollection(Client, scope);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHci/clusters/{clusterName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileHCIAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHciClusterConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AutomanageHciClusterConfigurationProfileAssignmentResource>> GetAutomanageHciClusterConfigurationProfileAssignmentAsync(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return await GetAutomanageHciClusterConfigurationProfileAssignments(scope).GetAsync(configurationProfileAssignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get information about a configuration profile assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHci/clusters/{clusterName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ConfigurationProfileHCIAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHciClusterConfigurationProfileAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="configurationProfileAssignmentName"> The configuration profile assignment name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="configurationProfileAssignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="configurationProfileAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AutomanageHciClusterConfigurationProfileAssignmentResource> GetAutomanageHciClusterConfigurationProfileAssignment(ResourceIdentifier scope, string configurationProfileAssignmentName, CancellationToken cancellationToken = default)
        {
            return GetAutomanageHciClusterConfigurationProfileAssignments(scope).Get(configurationProfileAssignmentName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageBestPracticeResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageBestPracticeResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageBestPracticeResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageBestPracticeResource"/> object. </returns>
        public virtual AutomanageBestPracticeResource GetAutomanageBestPracticeResource(ResourceIdentifier id)
        {
            AutomanageBestPracticeResource.ValidateResourceId(id);
            return new AutomanageBestPracticeResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageConfigurationProfileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageConfigurationProfileResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageConfigurationProfileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageConfigurationProfileResource"/> object. </returns>
        public virtual AutomanageConfigurationProfileResource GetAutomanageConfigurationProfileResource(ResourceIdentifier id)
        {
            AutomanageConfigurationProfileResource.ValidateResourceId(id);
            return new AutomanageConfigurationProfileResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageConfigurationProfileVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageConfigurationProfileVersionResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageConfigurationProfileVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageConfigurationProfileVersionResource"/> object. </returns>
        public virtual AutomanageConfigurationProfileVersionResource GetAutomanageConfigurationProfileVersionResource(ResourceIdentifier id)
        {
            AutomanageConfigurationProfileVersionResource.ValidateResourceId(id);
            return new AutomanageConfigurationProfileVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageVmConfigurationProfileAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageVmConfigurationProfileAssignmentResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageVmConfigurationProfileAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageVmConfigurationProfileAssignmentResource"/> object. </returns>
        public virtual AutomanageVmConfigurationProfileAssignmentResource GetAutomanageVmConfigurationProfileAssignmentResource(ResourceIdentifier id)
        {
            AutomanageVmConfigurationProfileAssignmentResource.ValidateResourceId(id);
            return new AutomanageVmConfigurationProfileAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageHcrpConfigurationProfileAssignmentResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/> object. </returns>
        public virtual AutomanageHcrpConfigurationProfileAssignmentResource GetAutomanageHcrpConfigurationProfileAssignmentResource(ResourceIdentifier id)
        {
            AutomanageHcrpConfigurationProfileAssignmentResource.ValidateResourceId(id);
            return new AutomanageHcrpConfigurationProfileAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageHciClusterConfigurationProfileAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageHciClusterConfigurationProfileAssignmentResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageHciClusterConfigurationProfileAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageHciClusterConfigurationProfileAssignmentResource"/> object. </returns>
        public virtual AutomanageHciClusterConfigurationProfileAssignmentResource GetAutomanageHciClusterConfigurationProfileAssignmentResource(ResourceIdentifier id)
        {
            AutomanageHciClusterConfigurationProfileAssignmentResource.ValidateResourceId(id);
            return new AutomanageHciClusterConfigurationProfileAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageVmConfigurationProfileAssignmentReportResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageVmConfigurationProfileAssignmentReportResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageVmConfigurationProfileAssignmentReportResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageVmConfigurationProfileAssignmentReportResource"/> object. </returns>
        public virtual AutomanageVmConfigurationProfileAssignmentReportResource GetAutomanageVmConfigurationProfileAssignmentReportResource(ResourceIdentifier id)
        {
            AutomanageVmConfigurationProfileAssignmentReportResource.ValidateResourceId(id);
            return new AutomanageVmConfigurationProfileAssignmentReportResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> object. </returns>
        public virtual AutomanageHcrpConfigurationProfileAssignmentReportResource GetAutomanageHcrpConfigurationProfileAssignmentReportResource(ResourceIdentifier id)
        {
            AutomanageHcrpConfigurationProfileAssignmentReportResource.ValidateResourceId(id);
            return new AutomanageHcrpConfigurationProfileAssignmentReportResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AutomanageHciClusterConfigurationProfileAssignmentReportResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AutomanageHciClusterConfigurationProfileAssignmentReportResource.CreateResourceIdentifier" /> to create an <see cref="AutomanageHciClusterConfigurationProfileAssignmentReportResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AutomanageHciClusterConfigurationProfileAssignmentReportResource"/> object. </returns>
        public virtual AutomanageHciClusterConfigurationProfileAssignmentReportResource GetAutomanageHciClusterConfigurationProfileAssignmentReportResource(ResourceIdentifier id)
        {
            AutomanageHciClusterConfigurationProfileAssignmentReportResource.ValidateResourceId(id);
            return new AutomanageHciClusterConfigurationProfileAssignmentReportResource(Client, id);
        }
    }
}
