// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Automanage
{
    /// <summary>
    /// A Class representing an AutomanageHcrpConfigurationProfileAssignmentReport along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct an <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetAutomanageHcrpConfigurationProfileAssignmentReportResource method.
    /// Otherwise you can get one from its parent resource <see cref="AutomanageHcrpConfigurationProfileAssignmentResource"/> using the GetAutomanageHcrpConfigurationProfileAssignmentReport method.
    /// </summary>
    public partial class AutomanageHcrpConfigurationProfileAssignmentReportResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="machineName"> The machineName. </param>
        /// <param name="configurationProfileAssignmentName"> The configurationProfileAssignmentName. </param>
        /// <param name="reportName"> The reportName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string machineName, string configurationProfileAssignmentName, string reportName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports/{reportName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsClientDiagnostics;
        private readonly HcrpReportsRestOperations _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsRestClient;
        private readonly AutomanageConfigurationProfileAssignmentReportData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Automanage/configurationProfileAssignments/reports";

        /// <summary> Initializes a new instance of the <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> class for mocking. </summary>
        protected AutomanageHcrpConfigurationProfileAssignmentReportResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal AutomanageHcrpConfigurationProfileAssignmentReportResource(ArmClient client, AutomanageConfigurationProfileAssignmentReportData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal AutomanageHcrpConfigurationProfileAssignmentReportResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Automanage", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string automanageHcrpConfigurationProfileAssignmentReportHCRPReportsApiVersion);
            _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsRestClient = new HcrpReportsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, automanageHcrpConfigurationProfileAssignmentReportHCRPReportsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual AutomanageConfigurationProfileAssignmentReportData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get information about a report associated with a configuration profile assignment run
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HCRPReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<AutomanageHcrpConfigurationProfileAssignmentReportResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsClientDiagnostics.CreateScope("AutomanageHcrpConfigurationProfileAssignmentReportResource.Get");
            scope.Start();
            try
            {
                var response = await _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutomanageHcrpConfigurationProfileAssignmentReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get information about a report associated with a configuration profile assignment run
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.Automanage/configurationProfileAssignments/{configurationProfileAssignmentName}/reports/{reportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HCRPReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-05-04</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AutomanageHcrpConfigurationProfileAssignmentReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<AutomanageHcrpConfigurationProfileAssignmentReportResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsClientDiagnostics.CreateScope("AutomanageHcrpConfigurationProfileAssignmentReportResource.Get");
            scope.Start();
            try
            {
                var response = _automanageHcrpConfigurationProfileAssignmentReportHCRPReportsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AutomanageHcrpConfigurationProfileAssignmentReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
