// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Automanage.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Automanage
{
    /// <summary>
    /// A class representing the AutomanageConfigurationProfileAssignmentReport data model.
    /// Definition of the report.
    /// </summary>
    public partial class AutomanageConfigurationProfileAssignmentReportData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfileAssignmentReportData"/>. </summary>
        public AutomanageConfigurationProfileAssignmentReportData()
        {
            Resources = new ChangeTrackingList<ConfigurationProfileAssignmentReportResourceDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomanageConfigurationProfileAssignmentReportData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> Start time of the configuration profile assignment processing. </param>
        /// <param name="endOn"> End time of the configuration profile assignment processing. </param>
        /// <param name="lastModifiedOn"> Last modified time of the configuration profile assignment processing. </param>
        /// <param name="duration"> Duration of the configuration profile assignment processing. </param>
        /// <param name="configurationProfileAssignmentProcessingType"> Type of the configuration profile assignment processing (Initial/Consistency). </param>
        /// <param name="status"> The status of the configuration profile assignment. </param>
        /// <param name="configurationProfile"> The configurationProfile linked to the assignment. </param>
        /// <param name="resources"> List of resources processed by the configuration profile assignment. </param>
        /// <param name="error"> Error message, if any, returned by the configuration profile assignment processing. </param>
        /// <param name="reportFormatVersion"> Version of the report format. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomanageConfigurationProfileAssignmentReportData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? startOn, DateTimeOffset? endOn, DateTimeOffset? lastModifiedOn, TimeSpan? duration, string configurationProfileAssignmentProcessingType, string status, string configurationProfile, IReadOnlyList<ConfigurationProfileAssignmentReportResourceDetails> resources, ResponseError error, string reportFormatVersion, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            StartOn = startOn;
            EndOn = endOn;
            LastModifiedOn = lastModifiedOn;
            Duration = duration;
            ConfigurationProfileAssignmentProcessingType = configurationProfileAssignmentProcessingType;
            Status = status;
            ConfigurationProfile = configurationProfile;
            Resources = resources;
            Error = error;
            ReportFormatVersion = reportFormatVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Start time of the configuration profile assignment processing. </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> End time of the configuration profile assignment processing. </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Last modified time of the configuration profile assignment processing. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Duration of the configuration profile assignment processing. </summary>
        public TimeSpan? Duration { get; }
        /// <summary> Type of the configuration profile assignment processing (Initial/Consistency). </summary>
        public string ConfigurationProfileAssignmentProcessingType { get; }
        /// <summary> The status of the configuration profile assignment. </summary>
        public string Status { get; }
        /// <summary> The configurationProfile linked to the assignment. </summary>
        public string ConfigurationProfile { get; }
        /// <summary> List of resources processed by the configuration profile assignment. </summary>
        public IReadOnlyList<ConfigurationProfileAssignmentReportResourceDetails> Resources { get; }
        /// <summary> Error message, if any, returned by the configuration profile assignment processing. </summary>
        public ResponseError Error { get; }
        /// <summary> Version of the report format. </summary>
        public string ReportFormatVersion { get; }
    }
}
