// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Automanage.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmAutomanageModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Automanage.AutomanageBestPracticeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="configuration"> configuration dictionary of the configuration profile. </param>
        /// <returns> A new <see cref="Automanage.AutomanageBestPracticeData"/> instance for mocking. </returns>
        public static AutomanageBestPracticeData AutomanageBestPracticeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BinaryData configuration = null)
        {
            return new AutomanageBestPracticeData(
                id,
                name,
                resourceType,
                systemData,
                configuration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Automanage.AutomanageConfigurationProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="configuration"> Properties of the configuration profile. </param>
        /// <returns> A new <see cref="Automanage.AutomanageConfigurationProfileData"/> instance for mocking. </returns>
        public static AutomanageConfigurationProfileData AutomanageConfigurationProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, BinaryData configuration = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AutomanageConfigurationProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                configuration != null ? new ConfigurationProfileProperties(configuration, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Automanage.AutomanageConfigurationProfileAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Properties of the configuration profile assignment. </param>
        /// <param name="managedBy"> Azure resource id. Indicates if this resource is managed by another Azure resource. </param>
        /// <returns> A new <see cref="Automanage.AutomanageConfigurationProfileAssignmentData"/> instance for mocking. </returns>
        public static AutomanageConfigurationProfileAssignmentData AutomanageConfigurationProfileAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AutomanageConfigurationProfileAssignmentProperties properties = null, string managedBy = null)
        {
            return new AutomanageConfigurationProfileAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                managedBy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutomanageConfigurationProfileAssignmentProperties"/>. </summary>
        /// <param name="configurationProfile"> The Automanage configurationProfile ARM Resource URI. </param>
        /// <param name="targetId"> The target VM resource URI. </param>
        /// <param name="status"> The status of onboarding, which only appears in the response. </param>
        /// <returns> A new <see cref="Models.AutomanageConfigurationProfileAssignmentProperties"/> instance for mocking. </returns>
        public static AutomanageConfigurationProfileAssignmentProperties AutomanageConfigurationProfileAssignmentProperties(ResourceIdentifier configurationProfile = null, ResourceIdentifier targetId = null, string status = null)
        {
            return new AutomanageConfigurationProfileAssignmentProperties(configurationProfile, targetId, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Automanage.AutomanageConfigurationProfileAssignmentReportData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> Start time of the configuration profile assignment processing. </param>
        /// <param name="endOn"> End time of the configuration profile assignment processing. </param>
        /// <param name="lastModifiedOn"> Last modified time of the configuration profile assignment processing. </param>
        /// <param name="duration"> Duration of the configuration profile assignment processing. </param>
        /// <param name="configurationProfileAssignmentProcessingType"> Type of the configuration profile assignment processing (Initial/Consistency). </param>
        /// <param name="status"> The status of the configuration profile assignment. </param>
        /// <param name="configurationProfile"> The configurationProfile linked to the assignment. </param>
        /// <param name="resources"> List of resources processed by the configuration profile assignment. </param>
        /// <param name="error"> Error message, if any, returned by the configuration profile assignment processing. </param>
        /// <param name="reportFormatVersion"> Version of the report format. </param>
        /// <returns> A new <see cref="Automanage.AutomanageConfigurationProfileAssignmentReportData"/> instance for mocking. </returns>
        public static AutomanageConfigurationProfileAssignmentReportData AutomanageConfigurationProfileAssignmentReportData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, DateTimeOffset? lastModifiedOn = null, TimeSpan? duration = null, string configurationProfileAssignmentProcessingType = null, string status = null, string configurationProfile = null, IEnumerable<ConfigurationProfileAssignmentReportResourceDetails> resources = null, ResponseError error = null, string reportFormatVersion = null)
        {
            resources ??= new List<ConfigurationProfileAssignmentReportResourceDetails>();

            return new AutomanageConfigurationProfileAssignmentReportData(
                id,
                name,
                resourceType,
                systemData,
                startOn,
                endOn,
                lastModifiedOn,
                duration,
                configurationProfileAssignmentProcessingType,
                status,
                configurationProfile,
                resources?.ToList(),
                error,
                reportFormatVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConfigurationProfileAssignmentReportResourceDetails"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="status"> Status of the resource. </param>
        /// <param name="error"> Error message, if any, returned when deploying the resource. </param>
        /// <returns> A new <see cref="Models.ConfigurationProfileAssignmentReportResourceDetails"/> instance for mocking. </returns>
        public static ConfigurationProfileAssignmentReportResourceDetails ConfigurationProfileAssignmentReportResourceDetails(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string status = null, ResponseError error = null)
        {
            return new ConfigurationProfileAssignmentReportResourceDetails(
                id,
                name,
                resourceType,
                systemData,
                status,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutomanageServicePrincipalData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="servicePrincipalId"> The Service Principal Id for the subscription. </param>
        /// <param name="isAuthorizationSet"> Returns the contributor RBAC Role exist or not for the Service Principal Id. </param>
        /// <returns> A new <see cref="Models.AutomanageServicePrincipalData"/> instance for mocking. </returns>
        public static AutomanageServicePrincipalData AutomanageServicePrincipalData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string servicePrincipalId = null, bool? isAuthorizationSet = null)
        {
            return new AutomanageServicePrincipalData(
                id,
                name,
                resourceType,
                systemData,
                servicePrincipalId,
                isAuthorizationSet,
                serializedAdditionalRawData: null);
        }
    }
}
