// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Authorization.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Authorization
{
    /// <summary>
    /// A class representing the RoleAssignmentSchedule data model.
    /// Role Assignment schedule
    /// </summary>
    public partial class RoleAssignmentScheduleData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentScheduleData"/>. </summary>
        internal RoleAssignmentScheduleData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role assignment schedule scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="roleAssignmentScheduleRequestId"> The id of roleAssignmentScheduleRequest used to create this roleAssignmentSchedule. </param>
        /// <param name="linkedRoleEligibilityScheduleId"> The id of roleEligibilitySchedule used to activated this roleAssignmentSchedule. </param>
        /// <param name="assignmentType"> Assignment type of the role assignment schedule. </param>
        /// <param name="memberType"> Membership type of the role assignment schedule. </param>
        /// <param name="status"> The status of the role assignment schedule. </param>
        /// <param name="startOn"> Start DateTime when role assignment schedule. </param>
        /// <param name="endOn"> End DateTime when role assignment schedule. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role assignment schedule was created. </param>
        /// <param name="updatedOn"> DateTime when role assignment schedule was modified. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleAssignmentScheduleData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string scope, ResourceIdentifier roleDefinitionId, Guid? principalId, RoleManagementPrincipalType? principalType, ResourceIdentifier roleAssignmentScheduleRequestId, ResourceIdentifier linkedRoleEligibilityScheduleId, RoleAssignmentScheduleAssignmentType? assignmentType, RoleManagementScheduleMemberType? memberType, RoleManagementScheduleStatus? status, DateTimeOffset? startOn, DateTimeOffset? endOn, string condition, string conditionVersion, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, RoleManagementExpandedProperties expandedProperties, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Scope = scope;
            RoleDefinitionId = roleDefinitionId;
            PrincipalId = principalId;
            PrincipalType = principalType;
            RoleAssignmentScheduleRequestId = roleAssignmentScheduleRequestId;
            LinkedRoleEligibilityScheduleId = linkedRoleEligibilityScheduleId;
            AssignmentType = assignmentType;
            MemberType = memberType;
            Status = status;
            StartOn = startOn;
            EndOn = endOn;
            Condition = condition;
            ConditionVersion = conditionVersion;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            ExpandedProperties = expandedProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The role assignment schedule scope. </summary>
        [WirePath("properties.scope")]
        public string Scope { get; }
        /// <summary> The role definition ID. </summary>
        [WirePath("properties.roleDefinitionId")]
        public ResourceIdentifier RoleDefinitionId { get; }
        /// <summary> The principal ID. </summary>
        [WirePath("properties.principalId")]
        public Guid? PrincipalId { get; }
        /// <summary> The principal type of the assigned principal ID. </summary>
        [WirePath("properties.principalType")]
        public RoleManagementPrincipalType? PrincipalType { get; }
        /// <summary> The id of roleAssignmentScheduleRequest used to create this roleAssignmentSchedule. </summary>
        [WirePath("properties.roleAssignmentScheduleRequestId")]
        public ResourceIdentifier RoleAssignmentScheduleRequestId { get; }
        /// <summary> The id of roleEligibilitySchedule used to activated this roleAssignmentSchedule. </summary>
        [WirePath("properties.linkedRoleEligibilityScheduleId")]
        public ResourceIdentifier LinkedRoleEligibilityScheduleId { get; }
        /// <summary> Assignment type of the role assignment schedule. </summary>
        [WirePath("properties.assignmentType")]
        public RoleAssignmentScheduleAssignmentType? AssignmentType { get; }
        /// <summary> Membership type of the role assignment schedule. </summary>
        [WirePath("properties.memberType")]
        public RoleManagementScheduleMemberType? MemberType { get; }
        /// <summary> The status of the role assignment schedule. </summary>
        [WirePath("properties.status")]
        public RoleManagementScheduleStatus? Status { get; }
        /// <summary> Start DateTime when role assignment schedule. </summary>
        [WirePath("properties.startDateTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> End DateTime when role assignment schedule. </summary>
        [WirePath("properties.endDateTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </summary>
        [WirePath("properties.condition")]
        public string Condition { get; }
        /// <summary> Version of the condition. Currently accepted value is '2.0'. </summary>
        [WirePath("properties.conditionVersion")]
        public string ConditionVersion { get; }
        /// <summary> DateTime when role assignment schedule was created. </summary>
        [WirePath("properties.createdOn")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> DateTime when role assignment schedule was modified. </summary>
        [WirePath("properties.updatedOn")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Additional properties of principal, scope and role definition. </summary>
        [WirePath("properties.expandedProperties")]
        public RoleManagementExpandedProperties ExpandedProperties { get; }
    }
}
