// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The detail of a user. </summary>
    public partial class RoleManagementUserInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleManagementUserInfo"/>. </summary>
        public RoleManagementUserInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RoleManagementUserInfo"/>. </summary>
        /// <param name="userType"> The type of user. </param>
        /// <param name="isBackup"> The value indicating whether the user is a backup fallback approver. </param>
        /// <param name="id"> The object id of the user. </param>
        /// <param name="description"> The description of the user. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleManagementUserInfo(RoleManagementUserType? userType, bool? isBackup, string id, string description, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UserType = userType;
            IsBackup = isBackup;
            Id = id;
            Description = description;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The type of user. </summary>
        [WirePath("userType")]
        public RoleManagementUserType? UserType { get; set; }
        /// <summary> The value indicating whether the user is a backup fallback approver. </summary>
        [WirePath("isBackup")]
        public bool? IsBackup { get; set; }
        /// <summary> The object id of the user. </summary>
        [WirePath("id")]
        public string Id { get; set; }
        /// <summary> The description of the user. </summary>
        [WirePath("description")]
        public string Description { get; set; }
    }
}
