// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> Type of the role assignment schedule expiration. </summary>
    public readonly partial struct RoleManagementScheduleExpirationType : IEquatable<RoleManagementScheduleExpirationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleManagementScheduleExpirationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleManagementScheduleExpirationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AfterDurationValue = "AfterDuration";
        private const string AfterDateTimeValue = "AfterDateTime";
        private const string NoExpirationValue = "NoExpiration";

        /// <summary> AfterDuration. </summary>
        public static RoleManagementScheduleExpirationType AfterDuration { get; } = new RoleManagementScheduleExpirationType(AfterDurationValue);
        /// <summary> AfterDateTime. </summary>
        public static RoleManagementScheduleExpirationType AfterDateTime { get; } = new RoleManagementScheduleExpirationType(AfterDateTimeValue);
        /// <summary> NoExpiration. </summary>
        public static RoleManagementScheduleExpirationType NoExpiration { get; } = new RoleManagementScheduleExpirationType(NoExpirationValue);
        /// <summary> Determines if two <see cref="RoleManagementScheduleExpirationType"/> values are the same. </summary>
        public static bool operator ==(RoleManagementScheduleExpirationType left, RoleManagementScheduleExpirationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleManagementScheduleExpirationType"/> values are not the same. </summary>
        public static bool operator !=(RoleManagementScheduleExpirationType left, RoleManagementScheduleExpirationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleManagementScheduleExpirationType"/>. </summary>
        public static implicit operator RoleManagementScheduleExpirationType(string value) => new RoleManagementScheduleExpirationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleManagementScheduleExpirationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleManagementScheduleExpirationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
