// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The name of the entity last modified it. </summary>
    public partial class RoleManagementPrincipal
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleManagementPrincipal"/>. </summary>
        internal RoleManagementPrincipal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RoleManagementPrincipal"/>. </summary>
        /// <param name="id"> The id of the principal made changes. </param>
        /// <param name="displayName"> The name of the principal made changes. </param>
        /// <param name="principalType"> Type of the principal. </param>
        /// <param name="email"> Email of principal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleManagementPrincipal(string id, string displayName, RoleManagementPrincipalType? principalType, string email, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            DisplayName = displayName;
            PrincipalType = principalType;
            Email = email;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The id of the principal made changes. </summary>
        [WirePath("id")]
        public string Id { get; }
        /// <summary> The name of the principal made changes. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; }
        /// <summary> Type of the principal. </summary>
        [WirePath("type")]
        public RoleManagementPrincipalType? PrincipalType { get; }
        /// <summary> Email of principal. </summary>
        [WirePath("email")]
        public string Email { get; }
    }
}
