// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The type of rule. </summary>
    internal readonly partial struct RoleManagementPolicyRuleType : IEquatable<RoleManagementPolicyRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleManagementPolicyRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RoleManagementPolicyApprovalRuleValue = "RoleManagementPolicyApprovalRule";
        private const string RoleManagementPolicyAuthenticationContextRuleValue = "RoleManagementPolicyAuthenticationContextRule";
        private const string RoleManagementPolicyEnablementRuleValue = "RoleManagementPolicyEnablementRule";
        private const string RoleManagementPolicyExpirationRuleValue = "RoleManagementPolicyExpirationRule";
        private const string RoleManagementPolicyNotificationRuleValue = "RoleManagementPolicyNotificationRule";

        /// <summary> RoleManagementPolicyApprovalRule. </summary>
        public static RoleManagementPolicyRuleType RoleManagementPolicyApprovalRule { get; } = new RoleManagementPolicyRuleType(RoleManagementPolicyApprovalRuleValue);
        /// <summary> RoleManagementPolicyAuthenticationContextRule. </summary>
        public static RoleManagementPolicyRuleType RoleManagementPolicyAuthenticationContextRule { get; } = new RoleManagementPolicyRuleType(RoleManagementPolicyAuthenticationContextRuleValue);
        /// <summary> RoleManagementPolicyEnablementRule. </summary>
        public static RoleManagementPolicyRuleType RoleManagementPolicyEnablementRule { get; } = new RoleManagementPolicyRuleType(RoleManagementPolicyEnablementRuleValue);
        /// <summary> RoleManagementPolicyExpirationRule. </summary>
        public static RoleManagementPolicyRuleType RoleManagementPolicyExpirationRule { get; } = new RoleManagementPolicyRuleType(RoleManagementPolicyExpirationRuleValue);
        /// <summary> RoleManagementPolicyNotificationRule. </summary>
        public static RoleManagementPolicyRuleType RoleManagementPolicyNotificationRule { get; } = new RoleManagementPolicyRuleType(RoleManagementPolicyNotificationRuleValue);
        /// <summary> Determines if two <see cref="RoleManagementPolicyRuleType"/> values are the same. </summary>
        public static bool operator ==(RoleManagementPolicyRuleType left, RoleManagementPolicyRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleManagementPolicyRuleType"/> values are not the same. </summary>
        public static bool operator !=(RoleManagementPolicyRuleType left, RoleManagementPolicyRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleManagementPolicyRuleType"/>. </summary>
        public static implicit operator RoleManagementPolicyRuleType(string value) => new RoleManagementPolicyRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleManagementPolicyRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleManagementPolicyRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
