// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The recipient type. </summary>
    public readonly partial struct RoleManagementPolicyRecipientType : IEquatable<RoleManagementPolicyRecipientType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyRecipientType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleManagementPolicyRecipientType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequestorValue = "Requestor";
        private const string ApproverValue = "Approver";
        private const string AdminValue = "Admin";

        /// <summary> Requestor. </summary>
        public static RoleManagementPolicyRecipientType Requestor { get; } = new RoleManagementPolicyRecipientType(RequestorValue);
        /// <summary> Approver. </summary>
        public static RoleManagementPolicyRecipientType Approver { get; } = new RoleManagementPolicyRecipientType(ApproverValue);
        /// <summary> Admin. </summary>
        public static RoleManagementPolicyRecipientType Admin { get; } = new RoleManagementPolicyRecipientType(AdminValue);
        /// <summary> Determines if two <see cref="RoleManagementPolicyRecipientType"/> values are the same. </summary>
        public static bool operator ==(RoleManagementPolicyRecipientType left, RoleManagementPolicyRecipientType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleManagementPolicyRecipientType"/> values are not the same. </summary>
        public static bool operator !=(RoleManagementPolicyRecipientType left, RoleManagementPolicyRecipientType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleManagementPolicyRecipientType"/>. </summary>
        public static implicit operator RoleManagementPolicyRecipientType(string value) => new RoleManagementPolicyRecipientType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleManagementPolicyRecipientType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleManagementPolicyRecipientType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
