// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The role management policy expiration rule. </summary>
    public partial class RoleManagementPolicyExpirationRule : RoleManagementPolicyRule
    {
        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyExpirationRule"/>. </summary>
        public RoleManagementPolicyExpirationRule()
        {
            RuleType = RoleManagementPolicyRuleType.RoleManagementPolicyExpirationRule;
        }

        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyExpirationRule"/>. </summary>
        /// <param name="id"> The id of the rule. </param>
        /// <param name="ruleType"> The type of rule. </param>
        /// <param name="target"> The target of the current rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="isExpirationRequired"> The value indicating whether expiration is required. </param>
        /// <param name="maximumDuration"> The maximum duration of expiration in timespan. </param>
        internal RoleManagementPolicyExpirationRule(string id, RoleManagementPolicyRuleType ruleType, RoleManagementPolicyRuleTarget target, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? isExpirationRequired, TimeSpan? maximumDuration) : base(id, ruleType, target, serializedAdditionalRawData)
        {
            IsExpirationRequired = isExpirationRequired;
            MaximumDuration = maximumDuration;
            RuleType = ruleType;
        }

        /// <summary> The value indicating whether expiration is required. </summary>
        [WirePath("isExpirationRequired")]
        public bool? IsExpirationRequired { get; set; }
        /// <summary> The maximum duration of expiration in timespan. </summary>
        [WirePath("maximumDuration")]
        public TimeSpan? MaximumDuration { get; set; }
    }
}
