// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The role management policy enablement rule. </summary>
    public partial class RoleManagementPolicyEnablementRule : RoleManagementPolicyRule
    {
        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyEnablementRule"/>. </summary>
        public RoleManagementPolicyEnablementRule()
        {
            EnablementRules = new ChangeTrackingList<RoleAssignmentEnablementRuleType>();
            RuleType = RoleManagementPolicyRuleType.RoleManagementPolicyEnablementRule;
        }

        /// <summary> Initializes a new instance of <see cref="RoleManagementPolicyEnablementRule"/>. </summary>
        /// <param name="id"> The id of the rule. </param>
        /// <param name="ruleType"> The type of rule. </param>
        /// <param name="target"> The target of the current rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="enablementRules"> The list of enabled rules. </param>
        internal RoleManagementPolicyEnablementRule(string id, RoleManagementPolicyRuleType ruleType, RoleManagementPolicyRuleTarget target, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<RoleAssignmentEnablementRuleType> enablementRules) : base(id, ruleType, target, serializedAdditionalRawData)
        {
            EnablementRules = enablementRules;
            RuleType = ruleType;
        }

        /// <summary> The list of enabled rules. </summary>
        [WirePath("enabledRules")]
        public IList<RoleAssignmentEnablementRuleType> EnablementRules { get; }
    }
}
