// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The RoleManagementExpandedProperties. </summary>
    public partial class RoleManagementExpandedProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleManagementExpandedProperties"/>. </summary>
        internal RoleManagementExpandedProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RoleManagementExpandedProperties"/>. </summary>
        /// <param name="principalId"> Id of the principal. </param>
        /// <param name="principalDisplayName"> Display name of the principal. </param>
        /// <param name="email"> Email id of the principal. </param>
        /// <param name="principalType"> Type of the principal. </param>
        /// <param name="roleDefinitionId"> Id of the role definition. </param>
        /// <param name="roleDefinitionDisplayName"> Display name of the role definition. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="scopeId"> Scope id of the resource. </param>
        /// <param name="scopeDisplayName"> Display name of the resource. </param>
        /// <param name="scopeType"> Type of the scope. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleManagementExpandedProperties(Guid? principalId, string principalDisplayName, string email, RoleManagementPrincipalType? principalType, ResourceIdentifier roleDefinitionId, string roleDefinitionDisplayName, AuthorizationRoleType? roleType, ResourceIdentifier scopeId, string scopeDisplayName, RoleManagementScopeType? scopeType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrincipalId = principalId;
            PrincipalDisplayName = principalDisplayName;
            Email = email;
            PrincipalType = principalType;
            RoleDefinitionId = roleDefinitionId;
            RoleDefinitionDisplayName = roleDefinitionDisplayName;
            RoleType = roleType;
            ScopeId = scopeId;
            ScopeDisplayName = scopeDisplayName;
            ScopeType = scopeType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the principal. </summary>
        [WirePath("principal.id")]
        public Guid? PrincipalId { get; }
        /// <summary> Display name of the principal. </summary>
        [WirePath("principal.displayName")]
        public string PrincipalDisplayName { get; }
        /// <summary> Email id of the principal. </summary>
        [WirePath("principal.email")]
        public string Email { get; }
        /// <summary> Type of the principal. </summary>
        [WirePath("principal.type")]
        public RoleManagementPrincipalType? PrincipalType { get; }
        /// <summary> Id of the role definition. </summary>
        [WirePath("roleDefinition.id")]
        public ResourceIdentifier RoleDefinitionId { get; }
        /// <summary> Display name of the role definition. </summary>
        [WirePath("roleDefinition.displayName")]
        public string RoleDefinitionDisplayName { get; }
        /// <summary> The role type. </summary>
        [WirePath("roleDefinition.type")]
        public AuthorizationRoleType? RoleType { get; }
        /// <summary> Scope id of the resource. </summary>
        [WirePath("scope.id")]
        public ResourceIdentifier ScopeId { get; }
        /// <summary> Display name of the resource. </summary>
        [WirePath("scope.displayName")]
        public string ScopeDisplayName { get; }
        /// <summary> Type of the scope. </summary>
        [WirePath("scope.type")]
        public RoleManagementScopeType? ScopeType { get; }
    }
}
