// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The assignment level to which rule is applied. </summary>
    public readonly partial struct RoleManagementAssignmentLevel : IEquatable<RoleManagementAssignmentLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleManagementAssignmentLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleManagementAssignmentLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssignmentValue = "Assignment";
        private const string EligibilityValue = "Eligibility";

        /// <summary> Assignment. </summary>
        public static RoleManagementAssignmentLevel Assignment { get; } = new RoleManagementAssignmentLevel(AssignmentValue);
        /// <summary> Eligibility. </summary>
        public static RoleManagementAssignmentLevel Eligibility { get; } = new RoleManagementAssignmentLevel(EligibilityValue);
        /// <summary> Determines if two <see cref="RoleManagementAssignmentLevel"/> values are the same. </summary>
        public static bool operator ==(RoleManagementAssignmentLevel left, RoleManagementAssignmentLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleManagementAssignmentLevel"/> values are not the same. </summary>
        public static bool operator !=(RoleManagementAssignmentLevel left, RoleManagementAssignmentLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleManagementAssignmentLevel"/>. </summary>
        public static implicit operator RoleManagementAssignmentLevel(string value) => new RoleManagementAssignmentLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleManagementAssignmentLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleManagementAssignmentLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
