// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Authorization.Models
{
    public partial class RoleManagementApprovalSettings : IUtf8JsonSerializable, IJsonModel<RoleManagementApprovalSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RoleManagementApprovalSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RoleManagementApprovalSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleManagementApprovalSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoleManagementApprovalSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsApprovalRequired))
            {
                writer.WritePropertyName("isApprovalRequired"u8);
                writer.WriteBooleanValue(IsApprovalRequired.Value);
            }
            if (Optional.IsDefined(IsApprovalRequiredForExtension))
            {
                writer.WritePropertyName("isApprovalRequiredForExtension"u8);
                writer.WriteBooleanValue(IsApprovalRequiredForExtension.Value);
            }
            if (Optional.IsDefined(IsRequestorJustificationRequired))
            {
                writer.WritePropertyName("isRequestorJustificationRequired"u8);
                writer.WriteBooleanValue(IsRequestorJustificationRequired.Value);
            }
            if (Optional.IsDefined(ApprovalMode))
            {
                writer.WritePropertyName("approvalMode"u8);
                writer.WriteStringValue(ApprovalMode.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ApprovalStages))
            {
                writer.WritePropertyName("approvalStages"u8);
                writer.WriteStartArray();
                foreach (var item in ApprovalStages)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RoleManagementApprovalSettings IJsonModel<RoleManagementApprovalSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleManagementApprovalSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RoleManagementApprovalSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRoleManagementApprovalSettings(document.RootElement, options);
        }

        internal static RoleManagementApprovalSettings DeserializeRoleManagementApprovalSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isApprovalRequired = default;
            bool? isApprovalRequiredForExtension = default;
            bool? isRequestorJustificationRequired = default;
            RoleManagementApprovalMode? approvalMode = default;
            IList<RoleManagementApprovalStage> approvalStages = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isApprovalRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isApprovalRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isApprovalRequiredForExtension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isApprovalRequiredForExtension = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isRequestorJustificationRequired"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isRequestorJustificationRequired = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("approvalMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    approvalMode = new RoleManagementApprovalMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("approvalStages"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RoleManagementApprovalStage> array = new List<RoleManagementApprovalStage>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RoleManagementApprovalStage.DeserializeRoleManagementApprovalStage(item, options));
                    }
                    approvalStages = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RoleManagementApprovalSettings(
                isApprovalRequired,
                isApprovalRequiredForExtension,
                isRequestorJustificationRequired,
                approvalMode,
                approvalStages ?? new ChangeTrackingList<RoleManagementApprovalStage>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsApprovalRequired), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isApprovalRequired: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsApprovalRequired))
                {
                    builder.Append("  isApprovalRequired: ");
                    var boolValue = IsApprovalRequired.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsApprovalRequiredForExtension), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isApprovalRequiredForExtension: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsApprovalRequiredForExtension))
                {
                    builder.Append("  isApprovalRequiredForExtension: ");
                    var boolValue = IsApprovalRequiredForExtension.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsRequestorJustificationRequired), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isRequestorJustificationRequired: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsRequestorJustificationRequired))
                {
                    builder.Append("  isRequestorJustificationRequired: ");
                    var boolValue = IsRequestorJustificationRequired.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApprovalMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  approvalMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApprovalMode))
                {
                    builder.Append("  approvalMode: ");
                    builder.AppendLine($"'{ApprovalMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApprovalStages), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  approvalStages: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ApprovalStages))
                {
                    if (ApprovalStages.Any())
                    {
                        builder.Append("  approvalStages: ");
                        builder.AppendLine("[");
                        foreach (var item in ApprovalStages)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  approvalStages: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RoleManagementApprovalSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleManagementApprovalSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RoleManagementApprovalSettings)} does not support writing '{options.Format}' format.");
            }
        }

        RoleManagementApprovalSettings IPersistableModel<RoleManagementApprovalSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RoleManagementApprovalSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRoleManagementApprovalSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RoleManagementApprovalSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RoleManagementApprovalSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
