// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> Role definition permissions. </summary>
    public partial class RoleDefinitionPermission
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RoleDefinitionPermission"/>. </summary>
        public RoleDefinitionPermission()
        {
            Actions = new ChangeTrackingList<string>();
            NotActions = new ChangeTrackingList<string>();
            DataActions = new ChangeTrackingList<string>();
            NotDataActions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="RoleDefinitionPermission"/>. </summary>
        /// <param name="actions"> Allowed actions. </param>
        /// <param name="notActions"> Denied actions. </param>
        /// <param name="dataActions"> Allowed Data actions. </param>
        /// <param name="notDataActions"> Denied Data actions. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RoleDefinitionPermission(IList<string> actions, IList<string> notActions, IList<string> dataActions, IList<string> notDataActions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Actions = actions;
            NotActions = notActions;
            DataActions = dataActions;
            NotDataActions = notDataActions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Allowed actions. </summary>
        [WirePath("actions")]
        public IList<string> Actions { get; }
        /// <summary> Denied actions. </summary>
        [WirePath("notActions")]
        public IList<string> NotActions { get; }
        /// <summary> Allowed Data actions. </summary>
        [WirePath("dataActions")]
        public IList<string> DataActions { get; }
        /// <summary> Denied Data actions. </summary>
        [WirePath("notDataActions")]
        public IList<string> NotDataActions { get; }
    }
}
