// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> Assignment type of the role assignment schedule. </summary>
    public readonly partial struct RoleAssignmentScheduleAssignmentType : IEquatable<RoleAssignmentScheduleAssignmentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentScheduleAssignmentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleAssignmentScheduleAssignmentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivatedValue = "Activated";
        private const string AssignedValue = "Assigned";

        /// <summary> Activated. </summary>
        public static RoleAssignmentScheduleAssignmentType Activated { get; } = new RoleAssignmentScheduleAssignmentType(ActivatedValue);
        /// <summary> Assigned. </summary>
        public static RoleAssignmentScheduleAssignmentType Assigned { get; } = new RoleAssignmentScheduleAssignmentType(AssignedValue);
        /// <summary> Determines if two <see cref="RoleAssignmentScheduleAssignmentType"/> values are the same. </summary>
        public static bool operator ==(RoleAssignmentScheduleAssignmentType left, RoleAssignmentScheduleAssignmentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleAssignmentScheduleAssignmentType"/> values are not the same. </summary>
        public static bool operator !=(RoleAssignmentScheduleAssignmentType left, RoleAssignmentScheduleAssignmentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleAssignmentScheduleAssignmentType"/>. </summary>
        public static implicit operator RoleAssignmentScheduleAssignmentType(string value) => new RoleAssignmentScheduleAssignmentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleAssignmentScheduleAssignmentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleAssignmentScheduleAssignmentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
