// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The type of enablement rule. </summary>
    public readonly partial struct RoleAssignmentEnablementRuleType : IEquatable<RoleAssignmentEnablementRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RoleAssignmentEnablementRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RoleAssignmentEnablementRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MultiFactorAuthenticationValue = "MultiFactorAuthentication";
        private const string JustificationValue = "Justification";
        private const string TicketingValue = "Ticketing";

        /// <summary> MultiFactorAuthentication. </summary>
        public static RoleAssignmentEnablementRuleType MultiFactorAuthentication { get; } = new RoleAssignmentEnablementRuleType(MultiFactorAuthenticationValue);
        /// <summary> Justification. </summary>
        public static RoleAssignmentEnablementRuleType Justification { get; } = new RoleAssignmentEnablementRuleType(JustificationValue);
        /// <summary> Ticketing. </summary>
        public static RoleAssignmentEnablementRuleType Ticketing { get; } = new RoleAssignmentEnablementRuleType(TicketingValue);
        /// <summary> Determines if two <see cref="RoleAssignmentEnablementRuleType"/> values are the same. </summary>
        public static bool operator ==(RoleAssignmentEnablementRuleType left, RoleAssignmentEnablementRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RoleAssignmentEnablementRuleType"/> values are not the same. </summary>
        public static bool operator !=(RoleAssignmentEnablementRuleType left, RoleAssignmentEnablementRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RoleAssignmentEnablementRuleType"/>. </summary>
        public static implicit operator RoleAssignmentEnablementRuleType(string value) => new RoleAssignmentEnablementRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RoleAssignmentEnablementRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RoleAssignmentEnablementRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
