// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> Expanded info of resource scope, role definition and policy. </summary>
    public partial class PolicyAssignmentProperties : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentProperties"/>. </summary>
        internal PolicyAssignmentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentProperties"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyId"> Id of the policy. </param>
        /// <param name="lastModifiedBy"> The name of the entity last modified it. </param>
        /// <param name="lastModifiedOn"> The last modified date time. </param>
        /// <param name="roleDefinitionId"> Id of the role definition. </param>
        /// <param name="roleDefinitionDisplayName"> Display name of the role definition. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="scopeId"> Scope id of the resource. </param>
        /// <param name="scopeDisplayName"> Display name of the resource. </param>
        /// <param name="scopeType"> Type of the scope. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PolicyAssignmentProperties(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceIdentifier policyId, RoleManagementPrincipal lastModifiedBy, DateTimeOffset? lastModifiedOn, ResourceIdentifier roleDefinitionId, string roleDefinitionDisplayName, AuthorizationRoleType? roleType, ResourceIdentifier scopeId, string scopeDisplayName, RoleManagementScopeType? scopeType, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            PolicyId = policyId;
            LastModifiedBy = lastModifiedBy;
            LastModifiedOn = lastModifiedOn;
            RoleDefinitionId = roleDefinitionId;
            RoleDefinitionDisplayName = roleDefinitionDisplayName;
            RoleType = roleType;
            ScopeId = scopeId;
            ScopeDisplayName = scopeDisplayName;
            ScopeType = scopeType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the policy. </summary>
        [WirePath("policy.id")]
        public ResourceIdentifier PolicyId { get; }
        /// <summary> The name of the entity last modified it. </summary>
        [WirePath("policy.lastModifiedBy")]
        public RoleManagementPrincipal LastModifiedBy { get; }
        /// <summary> The last modified date time. </summary>
        [WirePath("policy.lastModifiedDateTime")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Id of the role definition. </summary>
        [WirePath("roleDefinition.id")]
        public ResourceIdentifier RoleDefinitionId { get; }
        /// <summary> Display name of the role definition. </summary>
        [WirePath("roleDefinition.displayName")]
        public string RoleDefinitionDisplayName { get; }
        /// <summary> The role type. </summary>
        [WirePath("roleDefinition.type")]
        public AuthorizationRoleType? RoleType { get; }
        /// <summary> Scope id of the resource. </summary>
        [WirePath("scope.id")]
        public ResourceIdentifier ScopeId { get; }
        /// <summary> Display name of the resource. </summary>
        [WirePath("scope.displayName")]
        public string ScopeDisplayName { get; }
        /// <summary> Type of the scope. </summary>
        [WirePath("scope.type")]
        public RoleManagementScopeType? ScopeType { get; }
    }
}
