// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> The type of notification. </summary>
    public readonly partial struct NotificationDeliveryType : IEquatable<NotificationDeliveryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationDeliveryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationDeliveryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EmailValue = "Email";

        /// <summary> Email. </summary>
        public static NotificationDeliveryType Email { get; } = new NotificationDeliveryType(EmailValue);
        /// <summary> Determines if two <see cref="NotificationDeliveryType"/> values are the same. </summary>
        public static bool operator ==(NotificationDeliveryType left, NotificationDeliveryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationDeliveryType"/> values are not the same. </summary>
        public static bool operator !=(NotificationDeliveryType left, NotificationDeliveryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationDeliveryType"/>. </summary>
        public static implicit operator NotificationDeliveryType(string value) => new NotificationDeliveryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationDeliveryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationDeliveryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
