// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Authorization
{
    /// <summary>
    /// A Class representing a DenyAssignment along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="DenyAssignmentResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetDenyAssignmentResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetDenyAssignment method.
    /// </summary>
    public partial class DenyAssignmentResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="DenyAssignmentResource"/> instance. </summary>
        /// <param name="scope"> The scope. </param>
        /// <param name="denyAssignmentId"> The denyAssignmentId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string scope, string denyAssignmentId)
        {
            var resourceId = $"{scope}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _denyAssignmentClientDiagnostics;
        private readonly DenyAssignmentsRestOperations _denyAssignmentRestClient;
        private readonly DenyAssignmentData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Authorization/denyAssignments";

        /// <summary> Initializes a new instance of the <see cref="DenyAssignmentResource"/> class for mocking. </summary>
        protected DenyAssignmentResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DenyAssignmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal DenyAssignmentResource(ArmClient client, DenyAssignmentData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="DenyAssignmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal DenyAssignmentResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _denyAssignmentClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Authorization", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string denyAssignmentApiVersion);
            _denyAssignmentRestClient = new DenyAssignmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, denyAssignmentApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DenyAssignmentData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get the specified deny assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DenyAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DenyAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DenyAssignmentResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _denyAssignmentClientDiagnostics.CreateScope("DenyAssignmentResource.Get");
            scope.Start();
            try
            {
                var response = await _denyAssignmentRestClient.GetAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DenyAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the specified deny assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Authorization/denyAssignments/{denyAssignmentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DenyAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DenyAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DenyAssignmentResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _denyAssignmentClientDiagnostics.CreateScope("DenyAssignmentResource.Get");
            scope.Start();
            try
            {
                var response = _denyAssignmentRestClient.Get(Id.Parent, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DenyAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
