// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Authorization.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Authorization
{
    /// <summary>
    /// A class representing the AuthorizationRoleDefinition data model.
    /// Role definition.
    /// </summary>
    public partial class AuthorizationRoleDefinitionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationRoleDefinitionData"/>. </summary>
        public AuthorizationRoleDefinitionData()
        {
            Permissions = new ChangeTrackingList<RoleDefinitionPermission>();
            AssignableScopes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationRoleDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleName"> The role name. </param>
        /// <param name="description"> The role definition description. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="permissions"> Role definition permissions. </param>
        /// <param name="assignableScopes"> Role definition assignable scopes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationRoleDefinitionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string roleName, string description, AuthorizationRoleType? roleType, IList<RoleDefinitionPermission> permissions, IList<string> assignableScopes, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            RoleName = roleName;
            Description = description;
            RoleType = roleType;
            Permissions = permissions;
            AssignableScopes = assignableScopes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The role name. </summary>
        [WirePath("properties.roleName")]
        public string RoleName { get; set; }
        /// <summary> The role definition description. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The role type. </summary>
        [WirePath("properties.type")]
        public AuthorizationRoleType? RoleType { get; set; }
        /// <summary> Role definition permissions. </summary>
        [WirePath("properties.permissions")]
        public IList<RoleDefinitionPermission> Permissions { get; }
        /// <summary> Role definition assignable scopes. </summary>
        [WirePath("properties.assignableScopes")]
        public IList<string> AssignableScopes { get; }
    }
}
