// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Authorization.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmAuthorizationModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.AuthorizationClassicAdministrator"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="emailAddress"> The email address of the administrator. </param>
        /// <param name="role"> The role of the administrator. </param>
        /// <returns> A new <see cref="Models.AuthorizationClassicAdministrator"/> instance for mocking. </returns>
        public static AuthorizationClassicAdministrator AuthorizationClassicAdministrator(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string emailAddress = null, string role = null)
        {
            return new AuthorizationClassicAdministrator(
                id,
                name,
                resourceType,
                systemData,
                emailAddress,
                role,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.DenyAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="denyAssignmentName"> The display name of the deny assignment. </param>
        /// <param name="description"> The description of the deny assignment. </param>
        /// <param name="permissions"> An array of permissions that are denied by the deny assignment. </param>
        /// <param name="scope"> The deny assignment scope. </param>
        /// <param name="isAppliedToChildScopes"> Determines if the deny assignment applies to child scopes. Default value is false. </param>
        /// <param name="principals"> Array of principals to which the deny assignment applies. </param>
        /// <param name="excludePrincipals"> Array of principals to which the deny assignment does not apply. </param>
        /// <param name="isSystemProtected"> Specifies whether this deny assignment was created by Azure and cannot be edited or deleted. </param>
        /// <returns> A new <see cref="Authorization.DenyAssignmentData"/> instance for mocking. </returns>
        public static DenyAssignmentData DenyAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string denyAssignmentName = null, string description = null, IEnumerable<DenyAssignmentPermission> permissions = null, string scope = null, bool? isAppliedToChildScopes = null, IEnumerable<RoleManagementPrincipal> principals = null, IEnumerable<RoleManagementPrincipal> excludePrincipals = null, bool? isSystemProtected = null)
        {
            permissions ??= new List<DenyAssignmentPermission>();
            principals ??= new List<RoleManagementPrincipal>();
            excludePrincipals ??= new List<RoleManagementPrincipal>();

            return new DenyAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                denyAssignmentName,
                description,
                permissions?.ToList(),
                scope,
                isAppliedToChildScopes,
                principals?.ToList(),
                excludePrincipals?.ToList(),
                isSystemProtected,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DenyAssignmentPermission"/>. </summary>
        /// <param name="actions"> Actions to which the deny assignment does not grant access. </param>
        /// <param name="notActions"> Actions to exclude from that the deny assignment does not grant access. </param>
        /// <param name="dataActions"> Data actions to which the deny assignment does not grant access. </param>
        /// <param name="notDataActions"> Data actions to exclude from that the deny assignment does not grant access. </param>
        /// <param name="condition"> The conditions on the Deny assignment permission. This limits the resources it applies to. </param>
        /// <param name="conditionVersion"> Version of the condition. </param>
        /// <returns> A new <see cref="Models.DenyAssignmentPermission"/> instance for mocking. </returns>
        public static DenyAssignmentPermission DenyAssignmentPermission(IEnumerable<string> actions = null, IEnumerable<string> notActions = null, IEnumerable<string> dataActions = null, IEnumerable<string> notDataActions = null, string condition = null, string conditionVersion = null)
        {
            actions ??= new List<string>();
            notActions ??= new List<string>();
            dataActions ??= new List<string>();
            notDataActions ??= new List<string>();

            return new DenyAssignmentPermission(
                actions?.ToList(),
                notActions?.ToList(),
                dataActions?.ToList(),
                notDataActions?.ToList(),
                condition,
                conditionVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleManagementPrincipal"/>. </summary>
        /// <param name="id"> The id of the principal made changes. </param>
        /// <param name="displayName"> The name of the principal made changes. </param>
        /// <param name="principalType"> Type of the principal. </param>
        /// <param name="email"> Email of principal. </param>
        /// <returns> A new <see cref="Models.RoleManagementPrincipal"/> instance for mocking. </returns>
        public static RoleManagementPrincipal RoleManagementPrincipal(string id = null, string displayName = null, RoleManagementPrincipalType? principalType = null, string email = null)
        {
            return new RoleManagementPrincipal(id, displayName, principalType, email, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.AuthorizationProviderOperationsMetadataData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> The provider display name. </param>
        /// <param name="resourceTypes"> The provider resource types. </param>
        /// <param name="operations"> The provider operations. </param>
        /// <returns> A new <see cref="Authorization.AuthorizationProviderOperationsMetadataData"/> instance for mocking. </returns>
        public static AuthorizationProviderOperationsMetadataData AuthorizationProviderOperationsMetadataData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string displayName = null, IEnumerable<AuthorizationProviderResourceType> resourceTypes = null, IEnumerable<AuthorizationProviderOperationInfo> operations = null)
        {
            resourceTypes ??= new List<AuthorizationProviderResourceType>();
            operations ??= new List<AuthorizationProviderOperationInfo>();

            return new AuthorizationProviderOperationsMetadataData(
                id,
                name,
                resourceType,
                systemData,
                displayName,
                resourceTypes?.ToList(),
                operations?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AuthorizationProviderResourceType"/>. </summary>
        /// <param name="name"> The resource type name. </param>
        /// <param name="displayName"> The resource type display name. </param>
        /// <param name="operations"> The resource type operations. </param>
        /// <returns> A new <see cref="Models.AuthorizationProviderResourceType"/> instance for mocking. </returns>
        public static AuthorizationProviderResourceType AuthorizationProviderResourceType(string name = null, string displayName = null, IEnumerable<AuthorizationProviderOperationInfo> operations = null)
        {
            operations ??= new List<AuthorizationProviderOperationInfo>();

            return new AuthorizationProviderResourceType(name, displayName, operations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AuthorizationProviderOperationInfo"/>. </summary>
        /// <param name="name"> The operation name. </param>
        /// <param name="displayName"> The operation display name. </param>
        /// <param name="description"> The operation description. </param>
        /// <param name="origin"> The operation origin. </param>
        /// <param name="properties"> The operation properties. </param>
        /// <param name="isDataAction"> The dataAction flag to specify the operation type. </param>
        /// <returns> A new <see cref="Models.AuthorizationProviderOperationInfo"/> instance for mocking. </returns>
        public static AuthorizationProviderOperationInfo AuthorizationProviderOperationInfo(string name = null, string displayName = null, string description = null, string origin = null, BinaryData properties = null, bool? isDataAction = null)
        {
            return new AuthorizationProviderOperationInfo(
                name,
                displayName,
                description,
                origin,
                properties,
                isDataAction,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role assignment scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="description"> Description of role assignment. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently the only accepted value is '2.0'. </param>
        /// <param name="createdOn"> Time it was created. </param>
        /// <param name="updatedOn"> Time it was updated. </param>
        /// <param name="createdBy"> Id of the user who created the assignment. </param>
        /// <param name="updatedBy"> Id of the user who updated the assignment. </param>
        /// <param name="delegatedManagedIdentityResourceId"> Id of the delegated managed identity resource. </param>
        /// <returns> A new <see cref="Authorization.RoleAssignmentData"/> instance for mocking. </returns>
        public static RoleAssignmentData RoleAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, string description = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, string createdBy = null, string updatedBy = null, ResourceIdentifier delegatedManagedIdentityResourceId = null)
        {
            return new RoleAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                description,
                condition,
                conditionVersion,
                createdOn,
                updatedOn,
                createdBy,
                updatedBy,
                delegatedManagedIdentityResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleAssignmentCreateOrUpdateContent"/>. </summary>
        /// <param name="scope"> The role assignment scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="description"> Description of role assignment. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently the only accepted value is '2.0'. </param>
        /// <param name="createdOn"> Time it was created. </param>
        /// <param name="updatedOn"> Time it was updated. </param>
        /// <param name="createdBy"> Id of the user who created the assignment. </param>
        /// <param name="updatedBy"> Id of the user who updated the assignment. </param>
        /// <param name="delegatedManagedIdentityResourceId"> Id of the delegated managed identity resource. </param>
        /// <returns> A new <see cref="Models.RoleAssignmentCreateOrUpdateContent"/> instance for mocking. </returns>
        public static RoleAssignmentCreateOrUpdateContent RoleAssignmentCreateOrUpdateContent(string scope = null, ResourceIdentifier roleDefinitionId = null, Guid principalId = default, RoleManagementPrincipalType? principalType = null, string description = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, string createdBy = null, string updatedBy = null, ResourceIdentifier delegatedManagedIdentityResourceId = null)
        {
            return new RoleAssignmentCreateOrUpdateContent(
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                description,
                condition,
                conditionVersion,
                createdOn,
                updatedOn,
                createdBy,
                updatedBy,
                delegatedManagedIdentityResourceId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.AuthorizationRoleDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="roleName"> The role name. </param>
        /// <param name="description"> The role definition description. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="permissions"> Role definition permissions. </param>
        /// <param name="assignableScopes"> Role definition assignable scopes. </param>
        /// <returns> A new <see cref="Authorization.AuthorizationRoleDefinitionData"/> instance for mocking. </returns>
        public static AuthorizationRoleDefinitionData AuthorizationRoleDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string roleName = null, string description = null, AuthorizationRoleType? roleType = null, IEnumerable<RoleDefinitionPermission> permissions = null, IEnumerable<string> assignableScopes = null)
        {
            permissions ??= new List<RoleDefinitionPermission>();
            assignableScopes ??= new List<string>();

            return new AuthorizationRoleDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                roleName,
                description,
                roleType,
                permissions?.ToList(),
                assignableScopes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EligibleChildResource"/>. </summary>
        /// <param name="id"> The resource scope Id. </param>
        /// <param name="name"> The resource name. </param>
        /// <param name="resourceType"> The resource type. </param>
        /// <returns> A new <see cref="Models.EligibleChildResource"/> instance for mocking. </returns>
        public static EligibleChildResource EligibleChildResource(string id = null, string name = null, string resourceType = null)
        {
            return new EligibleChildResource(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleAssignmentScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role assignment schedule scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="roleAssignmentScheduleRequestId"> The id of roleAssignmentScheduleRequest used to create this roleAssignmentSchedule. </param>
        /// <param name="linkedRoleEligibilityScheduleId"> The id of roleEligibilitySchedule used to activated this roleAssignmentSchedule. </param>
        /// <param name="assignmentType"> Assignment type of the role assignment schedule. </param>
        /// <param name="memberType"> Membership type of the role assignment schedule. </param>
        /// <param name="status"> The status of the role assignment schedule. </param>
        /// <param name="startOn"> Start DateTime when role assignment schedule. </param>
        /// <param name="endOn"> End DateTime when role assignment schedule. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role assignment schedule was created. </param>
        /// <param name="updatedOn"> DateTime when role assignment schedule was modified. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <returns> A new <see cref="Authorization.RoleAssignmentScheduleData"/> instance for mocking. </returns>
        public static RoleAssignmentScheduleData RoleAssignmentScheduleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, ResourceIdentifier roleAssignmentScheduleRequestId = null, ResourceIdentifier linkedRoleEligibilityScheduleId = null, RoleAssignmentScheduleAssignmentType? assignmentType = null, RoleManagementScheduleMemberType? memberType = null, RoleManagementScheduleStatus? status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, RoleManagementExpandedProperties expandedProperties = null)
        {
            return new RoleAssignmentScheduleData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                roleAssignmentScheduleRequestId,
                linkedRoleEligibilityScheduleId,
                assignmentType,
                memberType,
                status,
                startOn,
                endOn,
                condition,
                conditionVersion,
                createdOn,
                updatedOn,
                expandedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleManagementExpandedProperties"/>. </summary>
        /// <param name="principalId"> Id of the principal. </param>
        /// <param name="principalDisplayName"> Display name of the principal. </param>
        /// <param name="email"> Email id of the principal. </param>
        /// <param name="principalType"> Type of the principal. </param>
        /// <param name="roleDefinitionId"> Id of the role definition. </param>
        /// <param name="roleDefinitionDisplayName"> Display name of the role definition. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="scopeId"> Scope id of the resource. </param>
        /// <param name="scopeDisplayName"> Display name of the resource. </param>
        /// <param name="scopeType"> Type of the scope. </param>
        /// <returns> A new <see cref="Models.RoleManagementExpandedProperties"/> instance for mocking. </returns>
        public static RoleManagementExpandedProperties RoleManagementExpandedProperties(Guid? principalId = null, string principalDisplayName = null, string email = null, RoleManagementPrincipalType? principalType = null, ResourceIdentifier roleDefinitionId = null, string roleDefinitionDisplayName = null, AuthorizationRoleType? roleType = null, ResourceIdentifier scopeId = null, string scopeDisplayName = null, RoleManagementScopeType? scopeType = null)
        {
            return new RoleManagementExpandedProperties(
                principalId,
                principalDisplayName,
                email,
                principalType,
                roleDefinitionId,
                roleDefinitionDisplayName,
                roleType,
                scopeId,
                scopeDisplayName,
                scopeType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleAssignmentScheduleInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role assignment schedule scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="roleAssignmentScheduleId"> Id of the master role assignment schedule. </param>
        /// <param name="originRoleAssignmentId"> Role Assignment Id in external system. </param>
        /// <param name="status"> The status of the role assignment schedule instance. </param>
        /// <param name="startOn"> The startDateTime of the role assignment schedule instance. </param>
        /// <param name="endOn"> The endDateTime of the role assignment schedule instance. </param>
        /// <param name="linkedRoleEligibilityScheduleId"> roleEligibilityScheduleId used to activate. </param>
        /// <param name="linkedRoleEligibilityScheduleInstanceId"> roleEligibilityScheduleInstanceId linked to this roleAssignmentScheduleInstance. </param>
        /// <param name="assignmentType"> Assignment type of the role assignment schedule. </param>
        /// <param name="memberType"> Membership type of the role assignment schedule. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role assignment schedule was created. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <returns> A new <see cref="Authorization.RoleAssignmentScheduleInstanceData"/> instance for mocking. </returns>
        public static RoleAssignmentScheduleInstanceData RoleAssignmentScheduleInstanceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, ResourceIdentifier roleAssignmentScheduleId = null, ResourceIdentifier originRoleAssignmentId = null, RoleManagementScheduleStatus? status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, ResourceIdentifier linkedRoleEligibilityScheduleId = null, ResourceIdentifier linkedRoleEligibilityScheduleInstanceId = null, RoleAssignmentScheduleAssignmentType? assignmentType = null, RoleManagementScheduleMemberType? memberType = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, RoleManagementExpandedProperties expandedProperties = null)
        {
            return new RoleAssignmentScheduleInstanceData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                roleAssignmentScheduleId,
                originRoleAssignmentId,
                status,
                startOn,
                endOn,
                linkedRoleEligibilityScheduleId,
                linkedRoleEligibilityScheduleInstanceId,
                assignmentType,
                memberType,
                condition,
                conditionVersion,
                createdOn,
                expandedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleAssignmentScheduleRequestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role assignment schedule request scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="requestType"> The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc. </param>
        /// <param name="status"> The status of the role assignment schedule request. </param>
        /// <param name="approvalId"> The approvalId of the role assignment schedule request. </param>
        /// <param name="targetRoleAssignmentScheduleId"> The resultant role assignment schedule id or the role assignment schedule id being updated. </param>
        /// <param name="targetRoleAssignmentScheduleInstanceId"> The role assignment schedule instance id being updated. </param>
        /// <param name="linkedRoleEligibilityScheduleId"> The linked role eligibility schedule id - to activate an eligibility. </param>
        /// <param name="justification"> Justification for the role assignment. </param>
        /// <param name="ticketInfo"> Ticket Info of the role assignment. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role assignment schedule request was created. </param>
        /// <param name="requestorId"> Id of the user who created this request. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <param name="startOn"> Start DateTime of the role assignment schedule. </param>
        /// <param name="expirationType"> Type of the role assignment schedule expiration. </param>
        /// <param name="endOn"> End DateTime of the role assignment schedule. </param>
        /// <param name="duration"> Duration of the role assignment schedule in TimeSpan. </param>
        /// <returns> A new <see cref="Authorization.RoleAssignmentScheduleRequestData"/> instance for mocking. </returns>
        public static RoleAssignmentScheduleRequestData RoleAssignmentScheduleRequestData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, RoleManagementScheduleRequestType? requestType = null, RoleManagementScheduleStatus? status = null, string approvalId = null, ResourceIdentifier targetRoleAssignmentScheduleId = null, ResourceIdentifier targetRoleAssignmentScheduleInstanceId = null, ResourceIdentifier linkedRoleEligibilityScheduleId = null, string justification = null, RoleAssignmentScheduleTicketInfo ticketInfo = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, Guid? requestorId = null, RoleManagementExpandedProperties expandedProperties = null, DateTimeOffset? startOn = null, RoleManagementScheduleExpirationType? expirationType = null, DateTimeOffset? endOn = null, TimeSpan? duration = null)
        {
            return new RoleAssignmentScheduleRequestData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                requestType,
                status,
                approvalId,
                targetRoleAssignmentScheduleId,
                targetRoleAssignmentScheduleInstanceId,
                linkedRoleEligibilityScheduleId,
                justification,
                ticketInfo,
                condition,
                conditionVersion,
                createdOn,
                requestorId,
                expandedProperties,
                startOn,
                expirationType,
                endOn,
                duration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleEligibilityScheduleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role eligibility schedule scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="roleEligibilityScheduleRequestId"> The id of roleEligibilityScheduleRequest used to create this roleAssignmentSchedule. </param>
        /// <param name="memberType"> Membership type of the role eligibility schedule. </param>
        /// <param name="status"> The status of the role eligibility schedule. </param>
        /// <param name="startOn"> Start DateTime when role eligibility schedule. </param>
        /// <param name="endOn"> End DateTime when role eligibility schedule. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role eligibility schedule was created. </param>
        /// <param name="updatedOn"> DateTime when role eligibility schedule was modified. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <returns> A new <see cref="Authorization.RoleEligibilityScheduleData"/> instance for mocking. </returns>
        public static RoleEligibilityScheduleData RoleEligibilityScheduleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, ResourceIdentifier roleEligibilityScheduleRequestId = null, RoleManagementScheduleMemberType? memberType = null, RoleManagementScheduleStatus? status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, RoleManagementExpandedProperties expandedProperties = null)
        {
            return new RoleEligibilityScheduleData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                roleEligibilityScheduleRequestId,
                memberType,
                status,
                startOn,
                endOn,
                condition,
                conditionVersion,
                createdOn,
                updatedOn,
                expandedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleEligibilityScheduleInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role eligibility schedule scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="roleEligibilityScheduleId"> Id of the master role eligibility schedule. </param>
        /// <param name="status"> The status of the role eligibility schedule instance. </param>
        /// <param name="startOn"> The startDateTime of the role eligibility schedule instance. </param>
        /// <param name="endOn"> The endDateTime of the role eligibility schedule instance. </param>
        /// <param name="memberType"> Membership type of the role eligibility schedule. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role eligibility schedule was created. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <returns> A new <see cref="Authorization.RoleEligibilityScheduleInstanceData"/> instance for mocking. </returns>
        public static RoleEligibilityScheduleInstanceData RoleEligibilityScheduleInstanceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, ResourceIdentifier roleEligibilityScheduleId = null, RoleManagementScheduleStatus? status = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, RoleManagementScheduleMemberType? memberType = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, RoleManagementExpandedProperties expandedProperties = null)
        {
            return new RoleEligibilityScheduleInstanceData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                roleEligibilityScheduleId,
                status,
                startOn,
                endOn,
                memberType,
                condition,
                conditionVersion,
                createdOn,
                expandedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleEligibilityScheduleRequestData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role eligibility schedule request scope. </param>
        /// <param name="roleDefinitionId"> The role definition ID. </param>
        /// <param name="principalId"> The principal ID. </param>
        /// <param name="principalType"> The principal type of the assigned principal ID. </param>
        /// <param name="requestType"> The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign etc. </param>
        /// <param name="status"> The status of the role eligibility schedule request. </param>
        /// <param name="approvalId"> The approvalId of the role eligibility schedule request. </param>
        /// <param name="targetRoleEligibilityScheduleId"> The resultant role eligibility schedule id or the role eligibility schedule id being updated. </param>
        /// <param name="targetRoleEligibilityScheduleInstanceId"> The role eligibility schedule instance id being updated. </param>
        /// <param name="justification"> Justification for the role eligibility. </param>
        /// <param name="ticketInfo"> Ticket Info of the role eligibility. </param>
        /// <param name="condition"> The conditions on the role assignment. This limits the resources it can be assigned to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName] StringEqualsIgnoreCase 'foo_storage_container'. </param>
        /// <param name="conditionVersion"> Version of the condition. Currently accepted value is '2.0'. </param>
        /// <param name="createdOn"> DateTime when role eligibility schedule request was created. </param>
        /// <param name="requestorId"> Id of the user who created this request. </param>
        /// <param name="expandedProperties"> Additional properties of principal, scope and role definition. </param>
        /// <param name="startOn"> Start DateTime of the role eligibility schedule. </param>
        /// <param name="expirationType"> Type of the role eligibility schedule expiration. </param>
        /// <param name="endOn"> End DateTime of the role eligibility schedule. </param>
        /// <param name="duration"> Duration of the role eligibility schedule in TimeSpan. </param>
        /// <returns> A new <see cref="Authorization.RoleEligibilityScheduleRequestData"/> instance for mocking. </returns>
        public static RoleEligibilityScheduleRequestData RoleEligibilityScheduleRequestData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, Guid? principalId = null, RoleManagementPrincipalType? principalType = null, RoleManagementScheduleRequestType? requestType = null, RoleManagementScheduleStatus? status = null, string approvalId = null, ResourceIdentifier targetRoleEligibilityScheduleId = null, ResourceIdentifier targetRoleEligibilityScheduleInstanceId = null, string justification = null, RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo = null, string condition = null, string conditionVersion = null, DateTimeOffset? createdOn = null, Guid? requestorId = null, RoleManagementExpandedProperties expandedProperties = null, DateTimeOffset? startOn = null, RoleManagementScheduleExpirationType? expirationType = null, DateTimeOffset? endOn = null, TimeSpan? duration = null)
        {
            return new RoleEligibilityScheduleRequestData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                principalId,
                principalType,
                requestType,
                status,
                approvalId,
                targetRoleEligibilityScheduleId,
                targetRoleEligibilityScheduleInstanceId,
                justification,
                ticketInfo,
                condition,
                conditionVersion,
                createdOn,
                requestorId,
                expandedProperties,
                startOn,
                expirationType,
                endOn,
                duration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleManagementPolicyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role management policy scope. </param>
        /// <param name="displayName"> The role management policy display name. </param>
        /// <param name="description"> The role management policy description. </param>
        /// <param name="isOrganizationDefault"> The role management policy is default policy. </param>
        /// <param name="lastModifiedBy"> The name of the entity last modified it. </param>
        /// <param name="lastModifiedOn"> The last modified date time. </param>
        /// <param name="rules">
        /// The rule applied to the policy.
        /// Please note <see cref="RoleManagementPolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RoleManagementPolicyApprovalRule"/>, <see cref="RoleManagementPolicyAuthenticationContextRule"/>, <see cref="RoleManagementPolicyEnablementRule"/>, <see cref="RoleManagementPolicyExpirationRule"/> and <see cref="RoleManagementPolicyNotificationRule"/>.
        /// </param>
        /// <param name="effectiveRules">
        /// The readonly computed rule applied to the policy.
        /// Please note <see cref="RoleManagementPolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RoleManagementPolicyApprovalRule"/>, <see cref="RoleManagementPolicyAuthenticationContextRule"/>, <see cref="RoleManagementPolicyEnablementRule"/>, <see cref="RoleManagementPolicyExpirationRule"/> and <see cref="RoleManagementPolicyNotificationRule"/>.
        /// </param>
        /// <param name="policyProperties"> Additional properties of scope. </param>
        /// <returns> A new <see cref="Authorization.RoleManagementPolicyData"/> instance for mocking. </returns>
        public static RoleManagementPolicyData RoleManagementPolicyData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, string displayName = null, string description = null, bool? isOrganizationDefault = null, RoleManagementPrincipal lastModifiedBy = null, DateTimeOffset? lastModifiedOn = null, IEnumerable<RoleManagementPolicyRule> rules = null, IEnumerable<RoleManagementPolicyRule> effectiveRules = null, RoleManagementPolicyProperties policyProperties = null)
        {
            rules ??= new List<RoleManagementPolicyRule>();
            effectiveRules ??= new List<RoleManagementPolicyRule>();

            return new RoleManagementPolicyData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                displayName,
                description,
                isOrganizationDefault,
                lastModifiedBy,
                lastModifiedOn,
                rules?.ToList(),
                effectiveRules?.ToList(),
                policyProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RoleManagementPolicyProperties"/>. </summary>
        /// <param name="scopeId"> Scope id of the resource. </param>
        /// <param name="scopeDisplayName"> Display name of the resource. </param>
        /// <param name="scopeType"> Type of the scope. </param>
        /// <returns> A new <see cref="Models.RoleManagementPolicyProperties"/> instance for mocking. </returns>
        public static RoleManagementPolicyProperties RoleManagementPolicyProperties(ResourceIdentifier scopeId = null, string scopeDisplayName = null, RoleManagementScopeType? scopeType = null)
        {
            return new RoleManagementPolicyProperties(scopeId, scopeDisplayName, scopeType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Authorization.RoleManagementPolicyAssignmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scope"> The role management policy scope. </param>
        /// <param name="roleDefinitionId"> The role definition of management policy assignment. </param>
        /// <param name="policyId"> The policy id role management policy assignment. </param>
        /// <param name="effectiveRules">
        /// The readonly computed rule applied to the policy.
        /// Please note <see cref="RoleManagementPolicyRule"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RoleManagementPolicyApprovalRule"/>, <see cref="RoleManagementPolicyAuthenticationContextRule"/>, <see cref="RoleManagementPolicyEnablementRule"/>, <see cref="RoleManagementPolicyExpirationRule"/> and <see cref="RoleManagementPolicyNotificationRule"/>.
        /// </param>
        /// <param name="policyAssignmentProperties"> Additional properties of scope, role definition and policy. </param>
        /// <returns> A new <see cref="Authorization.RoleManagementPolicyAssignmentData"/> instance for mocking. </returns>
        public static RoleManagementPolicyAssignmentData RoleManagementPolicyAssignmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string scope = null, ResourceIdentifier roleDefinitionId = null, ResourceIdentifier policyId = null, IEnumerable<RoleManagementPolicyRule> effectiveRules = null, PolicyAssignmentProperties policyAssignmentProperties = null)
        {
            effectiveRules ??= new List<RoleManagementPolicyRule>();

            return new RoleManagementPolicyAssignmentData(
                id,
                name,
                resourceType,
                systemData,
                scope,
                roleDefinitionId,
                policyId,
                effectiveRules?.ToList(),
                policyAssignmentProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PolicyAssignmentProperties"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="policyId"> Id of the policy. </param>
        /// <param name="lastModifiedBy"> The name of the entity last modified it. </param>
        /// <param name="lastModifiedOn"> The last modified date time. </param>
        /// <param name="roleDefinitionId"> Id of the role definition. </param>
        /// <param name="roleDefinitionDisplayName"> Display name of the role definition. </param>
        /// <param name="roleType"> The role type. </param>
        /// <param name="scopeId"> Scope id of the resource. </param>
        /// <param name="scopeDisplayName"> Display name of the resource. </param>
        /// <param name="scopeType"> Type of the scope. </param>
        /// <returns> A new <see cref="Models.PolicyAssignmentProperties"/> instance for mocking. </returns>
        public static PolicyAssignmentProperties PolicyAssignmentProperties(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier policyId = null, RoleManagementPrincipal lastModifiedBy = null, DateTimeOffset? lastModifiedOn = null, ResourceIdentifier roleDefinitionId = null, string roleDefinitionDisplayName = null, AuthorizationRoleType? roleType = null, ResourceIdentifier scopeId = null, string scopeDisplayName = null, RoleManagementScopeType? scopeType = null)
        {
            return new PolicyAssignmentProperties(
                id,
                name,
                resourceType,
                systemData,
                policyId,
                lastModifiedBy,
                lastModifiedOn,
                roleDefinitionId,
                roleDefinitionDisplayName,
                roleType,
                scopeId,
                scopeDisplayName,
                scopeType,
                serializedAdditionalRawData: null);
        }
    }
}
