// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Authorization.Samples
{
    public partial class Sample_RoleEligibilityScheduleResource
    {
        // GetRoleEligibilityScheduleByName
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetRoleEligibilityScheduleByName()
        {
            // Generated from example definition: specification/authorization/resource-manager/Microsoft.Authorization/stable/2020-10-01/examples/GetRoleEligibilityScheduleByName.json
            // this example is just showing the usage of "RoleEligibilitySchedules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RoleEligibilityScheduleResource created on azure
            // for more information of creating RoleEligibilityScheduleResource, please refer to the document of RoleEligibilityScheduleResource
            string scope = "providers/Microsoft.Subscription/subscriptions/dfa2a084-766f-4003-8ae1-c4aeb893a99f";
            string roleEligibilityScheduleName = "b1477448-2cc6-4ceb-93b4-54a202a89413";
            ResourceIdentifier roleEligibilityScheduleResourceId = RoleEligibilityScheduleResource.CreateResourceIdentifier(scope, roleEligibilityScheduleName);
            RoleEligibilityScheduleResource roleEligibilitySchedule = client.GetRoleEligibilityScheduleResource(roleEligibilityScheduleResourceId);

            // invoke the operation
            RoleEligibilityScheduleResource result = await roleEligibilitySchedule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RoleEligibilityScheduleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
