// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Authorization.Samples
{
    public partial class Sample_DenyAssignmentResource
    {
        // Get deny assignment by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDenyAssignmentByName()
        {
            // Generated from example definition: specification/authorization/resource-manager/Microsoft.Authorization/stable/2022-04-01/examples/GetDenyAssignmentByNameId.json
            // this example is just showing the usage of "DenyAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DenyAssignmentResource created on azure
            // for more information of creating DenyAssignmentResource, please refer to the document of DenyAssignmentResource
            string scope = "subscriptions/subId/resourcegroups/rgname";
            string denyAssignmentId = "denyAssignmentId";
            ResourceIdentifier denyAssignmentResourceId = DenyAssignmentResource.CreateResourceIdentifier(scope, denyAssignmentId);
            DenyAssignmentResource denyAssignment = client.GetDenyAssignmentResource(denyAssignmentResourceId);

            // invoke the operation
            DenyAssignmentResource result = await denyAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DenyAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
