// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Security.Attestation
{
    internal partial class PolicyCertificatesRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _instanceUrl;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of PolicyCertificatesRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="instanceUrl"> The attestation instance base URI, for example https://mytenant.attest.azure.net. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="instanceUrl"/> or <paramref name="apiVersion"/> is null. </exception>
        public PolicyCertificatesRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string instanceUrl, string apiVersion = "2020-10-01")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _instanceUrl = instanceUrl ?? throw new ArgumentNullException(nameof(instanceUrl));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateGetRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_instanceUrl, false);
            uri.AppendPath("/certificates", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Retrieves the set of certificates used to express policy for the current tenant. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<PolicyCertificatesResponse>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyCertificatesResponse.DeserializePolicyCertificatesResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Retrieves the set of certificates used to express policy for the current tenant. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<PolicyCertificatesResponse> Get(CancellationToken cancellationToken = default)
        {
            using var message = CreateGetRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyCertificatesResponse.DeserializePolicyCertificatesResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateAddRequest(string policyCertificateToAdd)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_instanceUrl, false);
            uri.AppendPath("/certificates:add", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStringValue(policyCertificateToAdd);
            request.Content = content;
            return message;
        }

        /// <summary> Adds a new attestation policy certificate to the set of policy management certificates. </summary>
        /// <param name="policyCertificateToAdd"> An RFC7519 JSON Web Token whose body is an RFC7517 JSON Web Key object. The RFC7519 JWT must be signed with one of the existing signing certificates. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyCertificateToAdd"/> is null. </exception>
        public async Task<Response<PolicyCertificatesModifyResponse>> AddAsync(string policyCertificateToAdd, CancellationToken cancellationToken = default)
        {
            if (policyCertificateToAdd == null)
            {
                throw new ArgumentNullException(nameof(policyCertificateToAdd));
            }

            using var message = CreateAddRequest(policyCertificateToAdd);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesModifyResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyCertificatesModifyResponse.DeserializePolicyCertificatesModifyResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Adds a new attestation policy certificate to the set of policy management certificates. </summary>
        /// <param name="policyCertificateToAdd"> An RFC7519 JSON Web Token whose body is an RFC7517 JSON Web Key object. The RFC7519 JWT must be signed with one of the existing signing certificates. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyCertificateToAdd"/> is null. </exception>
        public Response<PolicyCertificatesModifyResponse> Add(string policyCertificateToAdd, CancellationToken cancellationToken = default)
        {
            if (policyCertificateToAdd == null)
            {
                throw new ArgumentNullException(nameof(policyCertificateToAdd));
            }

            using var message = CreateAddRequest(policyCertificateToAdd);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesModifyResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyCertificatesModifyResponse.DeserializePolicyCertificatesModifyResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRemoveRequest(string policyCertificateToRemove)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_instanceUrl, false);
            uri.AppendPath("/certificates:remove", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStringValue(policyCertificateToRemove);
            request.Content = content;
            return message;
        }

        /// <summary> Removes the specified policy management certificate. Note that the final policy management certificate cannot be removed. </summary>
        /// <param name="policyCertificateToRemove"> An RFC7519 JSON Web Token whose body is an AttestationCertificateManagementBody object. The RFC7519 JWT must be signed with one of the existing signing certificates. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyCertificateToRemove"/> is null. </exception>
        public async Task<Response<PolicyCertificatesModifyResponse>> RemoveAsync(string policyCertificateToRemove, CancellationToken cancellationToken = default)
        {
            if (policyCertificateToRemove == null)
            {
                throw new ArgumentNullException(nameof(policyCertificateToRemove));
            }

            using var message = CreateRemoveRequest(policyCertificateToRemove);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesModifyResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = PolicyCertificatesModifyResponse.DeserializePolicyCertificatesModifyResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Removes the specified policy management certificate. Note that the final policy management certificate cannot be removed. </summary>
        /// <param name="policyCertificateToRemove"> An RFC7519 JSON Web Token whose body is an AttestationCertificateManagementBody object. The RFC7519 JWT must be signed with one of the existing signing certificates. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyCertificateToRemove"/> is null. </exception>
        public Response<PolicyCertificatesModifyResponse> Remove(string policyCertificateToRemove, CancellationToken cancellationToken = default)
        {
            if (policyCertificateToRemove == null)
            {
                throw new ArgumentNullException(nameof(policyCertificateToRemove));
            }

            using var message = CreateRemoveRequest(policyCertificateToRemove);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        PolicyCertificatesModifyResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = PolicyCertificatesModifyResponse.DeserializePolicyCertificatesModifyResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
