// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Security.Attestation
{
    /// <summary> Defines the "run time data" provided by the attestation target for use by the MAA. </summary>
    internal partial class RuntimeData
    {
        /// <summary> Initializes a new instance of <see cref="RuntimeData"/>. </summary>
        public RuntimeData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RuntimeData"/>. </summary>
        /// <param name="data"> UTF-8 encoded Runtime Data generated by the trusted environment. </param>
        /// <param name="dataType"> The type of data contained within the "data" field. </param>
        internal RuntimeData(byte[] data, DataType? dataType)
        {
            Data = data;
            DataType = dataType;
        }

        /// <summary> UTF-8 encoded Runtime Data generated by the trusted environment. </summary>
        public byte[] Data { get; set; }
        /// <summary> The type of data contained within the "data" field. </summary>
        public DataType? DataType { get; set; }
    }
}
