// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Security.Attestation
{
    /// <summary> The result of the operation. </summary>
    public readonly partial struct PolicyCertificateResolution : IEquatable<PolicyCertificateResolution>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyCertificateResolution"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyCertificateResolution(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsPresentValue = "IsPresent";
        private const string IsAbsentValue = "IsAbsent";

        /// <summary> After the operation was performed, the certificate is in the set of certificates. </summary>
        public static PolicyCertificateResolution IsPresent { get; } = new PolicyCertificateResolution(IsPresentValue);
        /// <summary> After the operation was performed, the certificate is no longer present in the set of certificates. </summary>
        public static PolicyCertificateResolution IsAbsent { get; } = new PolicyCertificateResolution(IsAbsentValue);
        /// <summary> Determines if two <see cref="PolicyCertificateResolution"/> values are the same. </summary>
        public static bool operator ==(PolicyCertificateResolution left, PolicyCertificateResolution right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyCertificateResolution"/> values are not the same. </summary>
        public static bool operator !=(PolicyCertificateResolution left, PolicyCertificateResolution right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyCertificateResolution"/>. </summary>
        public static implicit operator PolicyCertificateResolution(string value) => new PolicyCertificateResolution(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyCertificateResolution other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyCertificateResolution other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
