// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Security.Attestation
{
    [JsonConverter(typeof(PolicyCertificateModificationConverter))]
    internal partial class PolicyCertificateModification : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(InternalPolicyCertificate))
            {
                writer.WritePropertyName("policyCertificate"u8);
                writer.WriteObjectValue<JsonWebKey>(InternalPolicyCertificate);
            }
            writer.WriteEndObject();
        }

        internal static PolicyCertificateModification DeserializePolicyCertificateModification(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            JsonWebKey policyCertificate = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("policyCertificate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    policyCertificate = JsonWebKey.DeserializeJsonWebKey(property.Value);
                    continue;
                }
            }
            return new PolicyCertificateModification(policyCertificate);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static PolicyCertificateModification FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePolicyCertificateModification(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class PolicyCertificateModificationConverter : JsonConverter<PolicyCertificateModification>
        {
            public override void Write(Utf8JsonWriter writer, PolicyCertificateModification model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override PolicyCertificateModification Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializePolicyCertificateModification(document.RootElement);
            }
        }
    }
}
