// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Security.Attestation
{
    /// <summary> The JsonWebKeySet. </summary>
    internal partial class JsonWebKeySet
    {
        /// <summary> Initializes a new instance of <see cref="JsonWebKeySet"/>. </summary>
        internal JsonWebKeySet()
        {
            Keys = new ChangeTrackingList<JsonWebKey>();
        }

        /// <summary> Initializes a new instance of <see cref="JsonWebKeySet"/>. </summary>
        /// <param name="keys">
        /// The value of the "keys" parameter is an array of JWK values.  By
        /// default, the order of the JWK values within the array does not imply
        /// an order of preference among them, although applications of JWK Sets
        /// can choose to assign a meaning to the order for their purposes, if
        /// desired.
        /// </param>
        internal JsonWebKeySet(IReadOnlyList<JsonWebKey> keys)
        {
            Keys = keys;
        }

        /// <summary>
        /// The value of the "keys" parameter is an array of JWK values.  By
        /// default, the order of the JWK values within the array does not imply
        /// an order of preference among them, although applications of JWK Sets
        /// can choose to assign a meaning to the order for their purposes, if
        /// desired.
        /// </summary>
        public IReadOnlyList<JsonWebKey> Keys { get; }
    }
}
