// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Security.Attestation
{
    /// <summary> Specifies the type of the data encoded contained within the "data" field of a "RuntimeData" or "InitTimeData" object. </summary>
    internal readonly partial struct DataType : IEquatable<DataType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BinaryValue = "Binary";
        private const string JsonValue = "JSON";

        /// <summary> The contents of the field should be treated as binary and not interpreted by MAA. </summary>
        public static DataType Binary { get; } = new DataType(BinaryValue);
        /// <summary> The contents of the field should be treated as a JSON object and may be further interpreted by MAA. </summary>
        public static DataType Json { get; } = new DataType(JsonValue);
        /// <summary> Determines if two <see cref="DataType"/> values are the same. </summary>
        public static bool operator ==(DataType left, DataType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataType"/> values are not the same. </summary>
        public static bool operator !=(DataType left, DataType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataType"/>. </summary>
        public static implicit operator DataType(string value) => new DataType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
