// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Security.Attestation
{
    [JsonConverter(typeof(AttestationResultConverter))]
    public partial class AttestationResult
    {
        internal static AttestationResult DeserializeAttestationResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string jti = default;
            string iss = default;
            double? iat = default;
            double? exp = default;
            double? nbf = default;
            object cnf = default;
            string nonce = default;
            string xMsVer = default;
            object xMsRuntime = default;
            object xMsInittime = default;
            object xMsPolicy = default;
            string xMsAttestationType = default;
            JsonWebKey xMsPolicySigner = default;
            string xMsPolicyHash = default;
            bool? xMsSgxIsDebuggable = default;
            float? xMsSgxProductId = default;
            string xMsSgxMrenclave = default;
            string xMsSgxMrsigner = default;
            float? xMsSgxSvn = default;
            string xMsSgxEhd = default;
            object xMsSgxCollateral = default;
            string ver = default;
            bool? isDebuggable = default;
            object maaAttestationcollateral = default;
            string aasEhd = default;
            string maaEhd = default;
            float? productId = default;
            string sgxMrenclave = default;
            string sgxMrsigner = default;
            float? svn = default;
            string tee = default;
            JsonWebKey policySigner = default;
            string policyHash = default;
            string rpData = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("jti"u8))
                {
                    jti = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("iss"u8))
                {
                    iss = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("iat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iat = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("exp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exp = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("nbf"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nbf = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("cnf"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cnf = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("nonce"u8))
                {
                    nonce = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-ver"u8))
                {
                    xMsVer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-runtime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsRuntime = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("x-ms-inittime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsInittime = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("x-ms-policy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsPolicy = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("x-ms-attestation-type"u8))
                {
                    xMsAttestationType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-policy-signer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsPolicySigner = JsonWebKey.DeserializeJsonWebKey(property.Value);
                    continue;
                }
                if (property.NameEquals("x-ms-policy-hash"u8))
                {
                    xMsPolicyHash = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-is-debuggable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsSgxIsDebuggable = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-product-id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsSgxProductId = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-mrenclave"u8))
                {
                    xMsSgxMrenclave = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-mrsigner"u8))
                {
                    xMsSgxMrsigner = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-svn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsSgxSvn = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-ehd"u8))
                {
                    xMsSgxEhd = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("x-ms-sgx-collateral"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    xMsSgxCollateral = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("ver"u8))
                {
                    ver = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("is-debuggable"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDebuggable = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("maa-attestationcollateral"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maaAttestationcollateral = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("aas-ehd"u8))
                {
                    aasEhd = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maa-ehd"u8))
                {
                    maaEhd = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("product-id"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    productId = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("sgx-mrenclave"u8))
                {
                    sgxMrenclave = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sgx-mrsigner"u8))
                {
                    sgxMrsigner = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("svn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    svn = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("tee"u8))
                {
                    tee = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("policy_signer"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    policySigner = JsonWebKey.DeserializeJsonWebKey(property.Value);
                    continue;
                }
                if (property.NameEquals("policy_hash"u8))
                {
                    policyHash = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rp_data"u8))
                {
                    rpData = property.Value.GetString();
                    continue;
                }
            }
            return new AttestationResult(
                jti,
                iss,
                iat,
                exp,
                nbf,
                cnf,
                nonce,
                xMsVer,
                xMsRuntime,
                xMsInittime,
                xMsPolicy,
                xMsAttestationType,
                xMsPolicySigner,
                xMsPolicyHash,
                xMsSgxIsDebuggable,
                xMsSgxProductId,
                xMsSgxMrenclave,
                xMsSgxMrsigner,
                xMsSgxSvn,
                xMsSgxEhd,
                xMsSgxCollateral,
                ver,
                isDebuggable,
                maaAttestationcollateral,
                aasEhd,
                maaEhd,
                productId,
                sgxMrenclave,
                sgxMrsigner,
                svn,
                tee,
                policySigner,
                policyHash,
                rpData);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AttestationResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAttestationResult(document.RootElement);
        }

        internal partial class AttestationResultConverter : JsonConverter<AttestationResult>
        {
            public override void Write(Utf8JsonWriter writer, AttestationResult model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AttestationResult Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAttestationResult(document.RootElement);
            }
        }
    }
}
