// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Security.Attestation
{
    internal partial class AttestOpenEnclaveRequest : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Report))
            {
                writer.WritePropertyName("report"u8);
                writer.WriteBase64StringValue(Report, "U");
            }
            if (Optional.IsDefined(RuntimeData))
            {
                writer.WritePropertyName("runtimeData"u8);
                writer.WriteObjectValue(RuntimeData);
            }
            if (Optional.IsDefined(InitTimeData))
            {
                writer.WritePropertyName("initTimeData"u8);
                writer.WriteObjectValue(InitTimeData);
            }
            if (Optional.IsDefined(DraftPolicyForAttestation))
            {
                writer.WritePropertyName("draftPolicyForAttestation"u8);
                writer.WriteStringValue(DraftPolicyForAttestation);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
