// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Attestation.Models
{
    /// <summary> Status of attestation service. </summary>
    public readonly partial struct AttestationServiceStatus : IEquatable<AttestationServiceStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AttestationServiceStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AttestationServiceStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ReadyValue = "Ready";
        private const string NotReadyValue = "NotReady";
        private const string ErrorValue = "Error";

        /// <summary> Ready. </summary>
        public static AttestationServiceStatus Ready { get; } = new AttestationServiceStatus(ReadyValue);
        /// <summary> NotReady. </summary>
        public static AttestationServiceStatus NotReady { get; } = new AttestationServiceStatus(NotReadyValue);
        /// <summary> Error. </summary>
        public static AttestationServiceStatus Error { get; } = new AttestationServiceStatus(ErrorValue);
        /// <summary> Determines if two <see cref="AttestationServiceStatus"/> values are the same. </summary>
        public static bool operator ==(AttestationServiceStatus left, AttestationServiceStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AttestationServiceStatus"/> values are not the same. </summary>
        public static bool operator !=(AttestationServiceStatus left, AttestationServiceStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AttestationServiceStatus"/>. </summary>
        public static implicit operator AttestationServiceStatus(string value) => new AttestationServiceStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AttestationServiceStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AttestationServiceStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
