// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Attestation.Models
{
    /// <summary> Attestation Providers List. </summary>
    internal partial class AttestationProviderListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AttestationProviderListResult"/>. </summary>
        internal AttestationProviderListResult()
        {
            Value = new ChangeTrackingList<AttestationProviderData>();
        }

        /// <summary> Initializes a new instance of <see cref="AttestationProviderListResult"/>. </summary>
        /// <param name="systemData"> The system metadata relating to this resource. </param>
        /// <param name="value"> Attestation Provider array. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AttestationProviderListResult(SystemData systemData, IReadOnlyList<AttestationProviderData> value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SystemData = systemData;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The system metadata relating to this resource. </summary>
        public SystemData SystemData { get; }
        /// <summary> Attestation Provider array. </summary>
        public IReadOnlyList<AttestationProviderData> Value { get; }
    }
}
