// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Attestation.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableAttestationArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableAttestationArmClient"/> class for mocking. </summary>
        protected MockableAttestationArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableAttestationArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableAttestationArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableAttestationArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AttestationProviderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AttestationProviderResource.CreateResourceIdentifier" /> to create an <see cref="AttestationProviderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AttestationProviderResource"/> object. </returns>
        public virtual AttestationProviderResource GetAttestationProviderResource(ResourceIdentifier id)
        {
            AttestationProviderResource.ValidateResourceId(id);
            return new AttestationProviderResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AttestationPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AttestationPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create an <see cref="AttestationPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AttestationPrivateEndpointConnectionResource"/> object. </returns>
        public virtual AttestationPrivateEndpointConnectionResource GetAttestationPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            AttestationPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new AttestationPrivateEndpointConnectionResource(Client, id);
        }
    }
}
