// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Attestation.Models;

namespace Azure.ResourceManager.Attestation.Samples
{
    public partial class Sample_AttestationPrivateEndpointConnectionCollection
    {
        // AttestationProviderListPrivateEndpointConnections
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_AttestationProviderListPrivateEndpointConnections()
        {
            // Generated from example definition: specification/attestation/resource-manager/Microsoft.Attestation/preview/2021-06-01-preview/examples/AttestationProviderListPrivateEndpointConnections.json
            // this example is just showing the usage of "PrivateEndpointConnections_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttestationProviderResource created on azure
            // for more information of creating AttestationProviderResource, please refer to the document of AttestationProviderResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string providerName = "sto2527";
            ResourceIdentifier attestationProviderResourceId = AttestationProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, providerName);
            AttestationProviderResource attestationProvider = client.GetAttestationProviderResource(attestationProviderResourceId);

            // get the collection of this AttestationPrivateEndpointConnectionResource
            AttestationPrivateEndpointConnectionCollection collection = attestationProvider.GetAttestationPrivateEndpointConnections();

            // invoke the operation and iterate over the result
            await foreach (AttestationPrivateEndpointConnectionResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AttestationPrivateEndpointConnectionData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AttestationProviderGetPrivateEndpointConnection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AttestationProviderGetPrivateEndpointConnection()
        {
            // Generated from example definition: specification/attestation/resource-manager/Microsoft.Attestation/preview/2021-06-01-preview/examples/AttestationProviderGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttestationProviderResource created on azure
            // for more information of creating AttestationProviderResource, please refer to the document of AttestationProviderResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string providerName = "sto2527";
            ResourceIdentifier attestationProviderResourceId = AttestationProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, providerName);
            AttestationProviderResource attestationProvider = client.GetAttestationProviderResource(attestationProviderResourceId);

            // get the collection of this AttestationPrivateEndpointConnectionResource
            AttestationPrivateEndpointConnectionCollection collection = attestationProvider.GetAttestationPrivateEndpointConnections();

            // invoke the operation
            string privateEndpointConnectionName = "{privateEndpointConnectionName}";
            AttestationPrivateEndpointConnectionResource result = await collection.GetAsync(privateEndpointConnectionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AttestationPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AttestationProviderGetPrivateEndpointConnection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_AttestationProviderGetPrivateEndpointConnection()
        {
            // Generated from example definition: specification/attestation/resource-manager/Microsoft.Attestation/preview/2021-06-01-preview/examples/AttestationProviderGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttestationProviderResource created on azure
            // for more information of creating AttestationProviderResource, please refer to the document of AttestationProviderResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string providerName = "sto2527";
            ResourceIdentifier attestationProviderResourceId = AttestationProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, providerName);
            AttestationProviderResource attestationProvider = client.GetAttestationProviderResource(attestationProviderResourceId);

            // get the collection of this AttestationPrivateEndpointConnectionResource
            AttestationPrivateEndpointConnectionCollection collection = attestationProvider.GetAttestationPrivateEndpointConnections();

            // invoke the operation
            string privateEndpointConnectionName = "{privateEndpointConnectionName}";
            bool result = await collection.ExistsAsync(privateEndpointConnectionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AttestationProviderGetPrivateEndpointConnection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_AttestationProviderGetPrivateEndpointConnection()
        {
            // Generated from example definition: specification/attestation/resource-manager/Microsoft.Attestation/preview/2021-06-01-preview/examples/AttestationProviderGetPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttestationProviderResource created on azure
            // for more information of creating AttestationProviderResource, please refer to the document of AttestationProviderResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string providerName = "sto2527";
            ResourceIdentifier attestationProviderResourceId = AttestationProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, providerName);
            AttestationProviderResource attestationProvider = client.GetAttestationProviderResource(attestationProviderResourceId);

            // get the collection of this AttestationPrivateEndpointConnectionResource
            AttestationPrivateEndpointConnectionCollection collection = attestationProvider.GetAttestationPrivateEndpointConnections();

            // invoke the operation
            string privateEndpointConnectionName = "{privateEndpointConnectionName}";
            NullableResponse<AttestationPrivateEndpointConnectionResource> response = await collection.GetIfExistsAsync(privateEndpointConnectionName);
            AttestationPrivateEndpointConnectionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AttestationPrivateEndpointConnectionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // AttestationProviderPutPrivateEndpointConnection
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_AttestationProviderPutPrivateEndpointConnection()
        {
            // Generated from example definition: specification/attestation/resource-manager/Microsoft.Attestation/preview/2021-06-01-preview/examples/AttestationProviderPutPrivateEndpointConnection.json
            // this example is just showing the usage of "PrivateEndpointConnections_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AttestationProviderResource created on azure
            // for more information of creating AttestationProviderResource, please refer to the document of AttestationProviderResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res7687";
            string providerName = "sto9699";
            ResourceIdentifier attestationProviderResourceId = AttestationProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, providerName);
            AttestationProviderResource attestationProvider = client.GetAttestationProviderResource(attestationProviderResourceId);

            // get the collection of this AttestationPrivateEndpointConnectionResource
            AttestationPrivateEndpointConnectionCollection collection = attestationProvider.GetAttestationPrivateEndpointConnections();

            // invoke the operation
            string privateEndpointConnectionName = "{privateEndpointConnectionName}";
            AttestationPrivateEndpointConnectionData data = new AttestationPrivateEndpointConnectionData()
            {
                ConnectionState = new AttestationPrivateLinkServiceConnectionState()
                {
                    Status = AttestationPrivateEndpointServiceConnectionStatus.Approved,
                    Description = "Auto-Approved",
                },
            };
            ArmOperation<AttestationPrivateEndpointConnectionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, privateEndpointConnectionName, data);
            AttestationPrivateEndpointConnectionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AttestationPrivateEndpointConnectionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
