// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Astro.Models
{
    /// <summary> User details for an organization. </summary>
    public partial class AstroUserDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AstroUserDetails"/>. </summary>
        /// <param name="firstName"> First name of the user. </param>
        /// <param name="lastName"> Last name of the user. </param>
        /// <param name="emailAddress"> Email address of the user. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="firstName"/>, <paramref name="lastName"/> or <paramref name="emailAddress"/> is null. </exception>
        public AstroUserDetails(string firstName, string lastName, string emailAddress)
        {
            Argument.AssertNotNull(firstName, nameof(firstName));
            Argument.AssertNotNull(lastName, nameof(lastName));
            Argument.AssertNotNull(emailAddress, nameof(emailAddress));

            FirstName = firstName;
            LastName = lastName;
            EmailAddress = emailAddress;
        }

        /// <summary> Initializes a new instance of <see cref="AstroUserDetails"/>. </summary>
        /// <param name="firstName"> First name of the user. </param>
        /// <param name="lastName"> Last name of the user. </param>
        /// <param name="emailAddress"> Email address of the user. </param>
        /// <param name="upn"> User's principal name. </param>
        /// <param name="phoneNumber"> User's phone number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AstroUserDetails(string firstName, string lastName, string emailAddress, string upn, string phoneNumber, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstName = firstName;
            LastName = lastName;
            EmailAddress = emailAddress;
            Upn = upn;
            PhoneNumber = phoneNumber;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AstroUserDetails"/> for deserialization. </summary>
        internal AstroUserDetails()
        {
        }

        /// <summary> First name of the user. </summary>
        public string FirstName { get; set; }
        /// <summary> Last name of the user. </summary>
        public string LastName { get; set; }
        /// <summary> Email address of the user. </summary>
        public string EmailAddress { get; set; }
        /// <summary> User's principal name. </summary>
        public string Upn { get; set; }
        /// <summary> User's phone number. </summary>
        public string PhoneNumber { get; set; }
    }
}
